
/*** VBECS 2.1.0.1 SQL Script ***/

USE @DBNAME@
GO


/*****************************************************************************************
   Create a temporary ProductType table and save the original data
*****************************************************************************************/
IF OBJECT_ID(N'tempdb..#ProductType') IS NOT NULL
	DROP TABLE #ProductType
GO

CREATE TABLE dbo.#ProductType
	(
	[ProductTypeCode] [char](4) NOT NULL,
	[ProductTypeName] [varchar](60) NOT NULL,
	[ProductTypePrintName] [varchar](35) NOT NULL,
	[ComponentClassId] [int] NOT NULL,
	[IccbbaComponentClassId] [int] NULL,
	[SplitAllowedIndicator] [bit] NULL,
	[RetireDate] [datetime] NULL,
	[SortColumn] [smallint] NOT NULL,
	[LastUpdateDate] [datetime] NOT NULL,
	[LastUpdateUser] [varchar](30) NOT NULL,
	[LastUpdateFunctionId] [int] NOT NULL 
	)  ON [PRIMARY]
GO

INSERT INTO #ProductType 
	(ProductTypeCode, ProductTypeName, ProductTypePrintName, ComponentClassId, IccbbaComponentClassId, SplitAllowedIndicator, RetireDate,
	 SortColumn, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId)
SELECT 	 ProductTypeCode, ProductTypeName, ProductTypePrintName, ComponentClassId, IccbbaComponentClassId, SplitAllowedIndicator, RetireDate,
	 SortColumn, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId
  FROM dbo.ProductType
GO

/*****************************************************************************************
   Drop the constraints from the ProductType table
*****************************************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[FK_BloodProduct_ProductType]') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE [dbo].[BloodProduct] DROP CONSTRAINT FK_BloodProduct_ProductType
GO

if exists (select * from dbo.sysobjects where id = object_id(N'dbo.FK_PermittedProductModification_FromProductType') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE dbo.PermittedProductModification DROP CONSTRAINT FK_PermittedProductModification_FromProductType
GO

if exists (select * from dbo.sysobjects where id = object_id(N'dbo.FK_PermittedProductModification_ToProductType') and OBJECTPROPERTY(id, N'IsForeignKey') = 1)
ALTER TABLE dbo.PermittedProductModification DROP CONSTRAINT FK_PermittedProductModification_ToProductType
GO

/*****************************************************************************************
   Create the updated ProductType table
*****************************************************************************************/
if exists (select * from dbo.sysobjects where id = object_id(N'dbo.ProductType') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE dbo.ProductType
GO

CREATE TABLE [dbo].[ProductType](
	[ProductTypeCode] [char](4) NOT NULL,
	[ProductTypeName] [varchar](60) NOT NULL,
	[ProductTypePrintName] [varchar](35) NOT NULL,
	[ComponentClassId] [int] NOT NULL,
	[IccbbaComponentClassId] [int] NULL,
	[SplitAllowedIndicator] [bit] NOT NULL,
	[AboRhConfirmationRequired] [bit] NOT NULL,
	[RetireDate] [datetime] NULL,
	[SortColumn] [smallint] NOT NULL,
	[LastUpdateDate] [datetime] NOT NULL,
	[LastUpdateUser] [varchar](30) NOT NULL,
	[RowVersion] [timestamp] NOT NULL,
	[LastUpdateFunctionId] [int] NOT NULL,
 CONSTRAINT [PK_ProductType] PRIMARY KEY CLUSTERED 
(
	[ProductTypeCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[ProductType] ADD  CONSTRAINT [DF_ProductType_SplitAllowedIndicator]  DEFAULT ((0)) FOR [SplitAllowedIndicator]
GO

ALTER TABLE [dbo].[ProductType] ADD  CONSTRAINT [DF_ProductType_AboRhConfirmationRequired]  DEFAULT ((0)) FOR [AboRhConfirmationRequired]
GO

ALTER TABLE [dbo].[ProductType] ADD  CONSTRAINT [DF_ProductType_SortColumn]  DEFAULT ((0)) FOR [SortColumn]
GO

ALTER TABLE [dbo].[ProductType] ADD  CONSTRAINT [DF_ProductType_LastUpdateFunctionId]  DEFAULT ((0)) FOR [LastUpdateFunctionId]
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A classification of blood products.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProductType', @level2type=N'COLUMN',@level2name=N'ProductTypeCode'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Describes the blood product type code.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProductType', @level2type=N'COLUMN',@level2name=N'ProductTypeName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The short name for the blood product type used for printing labels.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProductType', @level2type=N'COLUMN',@level2name=N'ProductTypePrintName'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a higher-level blood component.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProductType', @level2type=N'COLUMN',@level2name=N'ComponentClassId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a higher-level blood component.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProductType', @level2type=N'COLUMN',@level2name=N'IccbbaComponentClassId'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates whether the product type allows a split modification.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProductType', @level2type=N'COLUMN',@level2name=N'SplitAllowedIndicator'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates whether the product type requires AboRh confirmation upon login. See BR_2.07.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProductType', @level2type=N'COLUMN',@level2name=N'AboRhConfirmationRequired'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date the product type was retired from use.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProductType', @level2type=N'COLUMN',@level2name=N'RetireDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A number that facilitates presenting values in a specified order.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProductType', @level2type=N'COLUMN',@level2name=N'SortColumn'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time the record was last updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProductType', @level2type=N'COLUMN',@level2name=N'LastUpdateDate'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The logon id of the user who performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProductType', @level2type=N'COLUMN',@level2name=N'LastUpdateUser'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This is used in the C# code as a mechanism for version-stamping table rows, which provides a means for concurrency control.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProductType', @level2type=N'COLUMN',@level2name=N'RowVersion'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The identifier of the VBECS function that performed the last update.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProductType', @level2type=N'COLUMN',@level2name=N'LastUpdateFunctionId'
GO


/*****************************************************************************************
   Reload the updated ProductAttribute table 
*****************************************************************************************/
INSERT INTO dbo.ProductType 
	(ProductTypeCode, ProductTypeName, ProductTypePrintName, ComponentClassId, IccbbaComponentClassId, SplitAllowedIndicator, RetireDate,  
	 SortColumn, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId)
SELECT 	 ProductTypeCode, ProductTypeName, ProductTypePrintName, ComponentClassId, IccbbaComponentClassId, SplitAllowedIndicator,  RetireDate,
	 SortColumn, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId
  FROM #ProductType
GO

ALTER TABLE [dbo].[PermittedProductModification]  WITH NOCHECK ADD  CONSTRAINT [FK_PermittedProductModification_FromProductType] FOREIGN KEY([FromProductTypeCode])
REFERENCES [dbo].[ProductType] ([ProductTypeCode])
GO

ALTER TABLE [dbo].[PermittedProductModification]  WITH NOCHECK ADD  CONSTRAINT [FK_PermittedProductModification_ToProductType] FOREIGN KEY([ToProductTypeCode])
REFERENCES [dbo].[ProductType] ([ProductTypeCode])
GO

ALTER TABLE [dbo].[BloodProduct] ADD CONSTRAINT [FK_BloodProduct_ProductType] FOREIGN KEY ([ProductTypeCode]) REFERENCES [dbo].[ProductType] ([ProductTypeCode])
GO

CREATE  INDEX [IX_ProductType_ComponentClassId] ON [dbo].[ProductType]([ComponentClassId]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_ProductType_IccbbaComponentClassId] ON [dbo].[ProductType]([IccbbaComponentClassId]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[ProductType] WITH NOCHECK ADD 
	CONSTRAINT [FK_ProductType_ComponentClass] FOREIGN KEY 
	(
		[ComponentClassId]
	) REFERENCES [dbo].[ComponentClass] (
		[ComponentClassId]
	),
	CONSTRAINT [FK_ProductType_IccbbaComponentClass] FOREIGN KEY 
	(
		[IccbbaComponentClassId]
	) REFERENCES [dbo].[IccbbaComponentClass] (
		[IccbbaComponentClassId]
	)
GO




DROP TABLE #ProductType


-- Update rows in [dbo].[ProductType]- Reference Data
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E001'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E002'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E003'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E004'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E005'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E006'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E007'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E008'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E009'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E034'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E035'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E036'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E037'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E038'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E039'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E049'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E050'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E051'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E052'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E053'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E054'
UPDATE [dbo].[ProductType] SET [AboRhConfirmationRequired]=1, [LastUpdateDate]='2015-05-06 00:00:00.000', [LastUpdateUser]='vhaishadupok' WHERE [ProductTypeCode]='E057'
-- Operation applied to 22 rows out of 22


/****** CR 3567 ****** replace @DBNAME@ with the Database name ******/ 
USE @DBNAME@
GO
-- Add row to [dbo].[AntibodyType]
INSERT INTO [dbo].[AntibodyType] ([AntibodyTypeId], [AntibodyTypeName], [AntibodyReferenceCode], [ClinicallySignificantIndicator], [SortColumn], [LastUpdateDate], 
[LastUpdateUser], [LastUpdateFunctionId]) 
VALUES (88, 'Serologic Crossmatch Test Required', 'AB084', 0, 78, '2015-04-23 00:00:00.000', 'vhaishadupok', 0)

-- Add row to [dbo].[tmplAntibodyParameter]
INSERT INTO [dbo].[tmplAntibodyParameter] ([AntibodyParameterGuid], [AntibodyTypeId], [HigherLevelOverrideIndicator], [CanChangeIndicator], [CompatibilityPercentage]) 
VALUES ('706589f4-bc86-401a-a691-6f0e7c970d44', 88, 0, 0, 0)



/****** Inserts rows into the AntibodyParameter table for each division configured******/ 
INSERT INTO [@DBNAME@].[dbo].[AntibodyParameter] ([AntibodyParameterGuid],[AntibodyTypeId],[HigherLevelOverrideIndicator],[CanChangeIndicator],
[CompatibilityPercentage],[DivisionCode],[LastUpdateDate],[LastUpdateUser],[LastUpdateFunctionId])
SELECT TOP 20 NEWID() 
,88 
,[HigherLevelOverrideIndicator] 
,[CanChangeIndicator] 
,[CompatibilityPercentage] 
,[DivisionCode] 
,GETDATE() 
,'VBECS' 
,[LastUpdateFunctionId] 
FROM [@DBNAME@].[dbo].[AntibodyParameter] WHERE antibodytypeid = 69




--Delete spGetBloodProductByType 

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetBloodProductByType]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[spGetBloodProductByType]
GO



/******************************************************
* Functions, Stored Procedure and View updates
******************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[fnUnitStatusCode]') and xtype in (N'FN', N'IF', N'TF'))
drop function dbo.fnUnitStatusCode
GO

/****** Object:  UserDefinedFunction [dbo].[fnUnitStatusCode]    Script Date: 5/8/2015 2:56:14 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO


/*********************************************************************************************************************
**
**  Desc:   Retrieves the current status code for a particular blood unit
**
**  Author: 
**
**  Date:   N/A
**
**********************************************************************************************************************
**	Modified:
**	Date			Name			Description
**	-------------	-------			---------------
**	07/07/2005					** Reviewed for compliance with database standards and recommendations **
**									Added comment header, added object owners, formatted SQL		
**	08/30/2005					Replaced list of product codes with reference to component class ID in WHERE clause  (for RBC and whole blood)		
**	10/14/2005					The review for compliance above implemented the mandate to prefix objects with an explicit owner improperly.
**									I prefixed all objects with dbo and also used Aliases for queries with several tables, this has resulted in a significant increase in performance.
**	01/17/2006					Since modifications are required to create BloodUnitTest records for Abo/Rh confirmation (to keep a RBC in avaible status) and
**									for SickleCell and CMV indicators, we are created "dummy" records in the database with RecordStatusCode of M.  This sproc needs
**									to include M in it's BloodUnitTest search in determining Available status
**	01/23/2006		    			** Reviewed for compliance with database standards and recommendations **
**	03/23/2006					Expanding IN statements (where applicable) to conform to Database Standards and improve performance
**	04/11/2006					Adding Check for TestingLimitIndicator - If true, UC2 passed as Warning, and unit is still in Limited Status
**	12/07/2006					Checking filter for Abo/Rh Confirmations to NOT include Invalidated Tests CR2082
**	02/08/2007					** Reviewed for compliance with database standards and recommendations **
**									Removed commented-out code
**	05/18/2012					**SQL 2008 Upgrade** - Line 94 - replaced .BUS.LastUpdateDate with BUS.LastUpdateDate
**	05/06/2015					CR3558 - swapping logic to determine "Limited" status from ProductType.AboRhConfirmationRequired
**	05/08/2015					** Reviewed for compliance with database standards and recommendations **
*********************************************************************************************************************/
CREATE FUNCTION [dbo].[fnUnitStatusCode]
(
    @bloodunitguid UNIQUEIDENTIFIER,
    @ignorefinalstatus BIT = 0
)
RETURNS CHAR(1)
AS
BEGIN
    DECLARE @rhfactorcode			CHAR(1)
    DECLARE @bloodtypecode			CHAR(2)
    DECLARE @bloodunitshipmentguid	UNIQUEIDENTIFIER
    DECLARE @servicetypeindicator	CHAR(1)
    DECLARE @testinglimitindicator 	BIT
	DECLARE @confirmationRequired	BIT

    IF NOT EXISTS( SELECT 1 FROM dbo.BloodUnit BU
                   WHERE	BU.BloodUnitGuid = @bloodunitguid )
			RETURN NULL
    --
    --This function can be used in UC_13 to determine the status before moving to a final status
    --by setting @ignorefinalstatus to 1, in all other cases the actual status will be returned
    IF (@ignorefinalstatus <> 1)
    BEGIN
		--
		--Discarded (check for discard canned comment guid on blood unit status record)
		--
		IF EXISTS( SELECT 1 FROM dbo.BloodUnitStatus BUS
                   WHERE    BUS.BloodUnitGuid = @bloodunitguid 
                        AND BUS.DiscardCannedCommentGuid IS NOT NULL )
			RETURN 'D'
		--
		--Transfused (check for active patient transfusion record)
		--
		IF EXISTS( SELECT 1 FROM dbo.PatientTransfusion PT
                   WHERE    PT.BloodUnitGuid = @bloodunitguid 
                        AND PT.RecordStatusCode = 'A' )
			RETURN 'T'
		--
		--Modified (check for active blood unit modification record)
		--
		IF EXISTS( SELECT 1 FROM dbo.BloodUnitModification BUM
                   WHERE    BUM.FromBloodUnitGuid = @bloodunitguid 
                        AND BUM.ToBloodUnitGuid != @bloodunitguid 
                        AND BUM.RecordStatusCode = 'A')
			RETURN 'M'
		--
		--We must get the most recent shipment because it may have been shipped out and back again!
		SELECT TOP 1 
			@bloodunitshipmentguid = BUS.BloodUnitShipmentGuid 
		FROM 
			dbo.BloodUnitShipment BUS
		WHERE 
			BUS.BloodUnitGuid = @bloodunitguid
		AND
			BUS.RecordStatusCode = 'A' 
		ORDER BY 
			BUS.LastUpdateDate DESC
		--
		--Transferred (check for shipment date on outgoing shipment record)
		--
		IF EXISTS( SELECT 1 FROM dbo.BloodUnitShipment BUS
                   JOIN     dbo.Shipment S ON S.ShipmentGuid = BUS.OutgoingShipmentGuid 
                   WHERE    BUS.BloodUnitShipmentGuid = @bloodunitshipmentguid 
                        AND S.ShipmentDate IS NOT NULL)
			RETURN 'X'
    END
	--
	--Issued (check for issued unit record with no return date)
	--
	IF EXISTS( SELECT 1 FROM dbo.IssuedUnit IU
               WHERE    IU.BloodUnitGuid = @bloodunitguid 
                    AND IU.ReturnDateTime IS NULL )
		RETURN 'I'
    --
    --Crossmatched/Assigned (check for active ordered unit record with no release date
    --
    IF EXISTS( SELECT 1 FROM dbo.OrderedUnit OU
               WHERE    OU.BloodUnitGuid = @bloodunitguid
                    AND OU.OrderedComponentGuid IS NOT NULL 
                    AND OU.RecordStatusCode = 'A'
                    AND OU.ReleaseDate IS NULL )
    BEGIN
    	IF EXISTS( SELECT 1 FROM dbo.OrderedUnit OU 
                   WHERE    OU.BloodUnitGuid = @bloodunitguid
                   AND OU.OrderedComponentGuid IS NOT NULL 
                        AND OU.RecordStatusCode = 'A' 
                        AND OU.ReleaseDate IS NULL
                        AND (dbo.fnOrderedUnitCrossmatchResultCode(OU.OrderedUnitGuid) = 'C'
			OR dbo.fnOrderedUnitCrossmatchResultCode(OU.OrderedUnitGuid)  = 'E'
			OR dbo.fnOrderedUnitCrossmatchResultCode(OU.OrderedUnitGuid)  = 'G'))
    		RETURN 'C'
    	ELSE
    		RETURN 'S'
    END
	--
	--We must get product type and ABO/Rh to determine whether its Limited or Available
	SELECT	
		@rhfactorcode = BUM.RhFactorCode,
		@bloodtypecode = BUM.BloodTypeCode,
		@servicetypeindicator = V.ServiceTypeIndicator,
		@testinglimitindicator = BUS.TestingLimitIndicator,
		@confirmationRequired = PT.AboRhConfirmationRequired
	FROM    
        dbo.BloodUnit BU
	JOIN    
        dbo.BloodUnitMedia  BUM ON BUM.BloodUnitGuid = BU.BloodUnitGuid
	JOIN    
        dbo.BloodProduct BP ON BP.BloodProductGuid = BU.BloodProductGuid
	JOIN
        dbo.VamcDivision V ON V.DivisionCode = BU.DivisionCode
	JOIN
		dbo.BloodUnitStatus BUS ON BUS.BloodUnitGuid = BU.BloodUnitGuid
	JOIN
		dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode
	WHERE
        BU.BloodUnitGuid = @bloodunitguid

	--
	--Limited (check for lack of active ABO or Rh test)
	--
	IF @servicetypeindicator = 1 AND @confirmationRequired = 1 -- BR_2.07 (CR3558) - some types required confirmation
	BEGIN
		IF NOT EXISTS( SELECT 1 FROM dbo.BloodUnitTest BUT 
                       				WHERE    BUT.BloodUnitGuid = @bloodunitguid 
			                            AND 	(BUT.RecordStatusCode = 'A' OR BUT.RecordStatusCode = 'M')	--Split units inherit parent tests, but are hidden from the user
                           				AND 	BUT.BloodTestTypeId = 18 
                            			AND 	BUT.TestResultId = @bloodtypecode)
			RETURN 'L'
		ELSE
			IF @testinglimitindicator = 1
				RETURN 'L'
		
		IF @rhfactorcode = 'N' -- Neg units need Rh confirmation
		BEGIN
		IF NOT EXISTS( SELECT 1 FROM dbo.BloodUnitTest  BUT
                      	 			WHERE    BUT.BloodUnitGuid = @bloodunitguid 
			                            AND 	(BUT.RecordStatusCode = 'A' OR BUT.RecordStatusCode = 'M')	--Split units inherit parent tests, but are hidden from the user
			                            AND 	BUT.BloodTestTypeId = 21 
			                            AND 	BUT.TestResultId = @rhfactorcode )
			RETURN 'L'
		ELSE
			IF @testinglimitindicator = 1
				RETURN 'L'
		END
	END
	--
	--Available (default)
	--
	RETURN 'A'
END




GO





if exists (select * from dbo.sysobjects where id = object_id(N'dbo.vw_BloodShipPatientAllCurrent') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view dbo.vw_BloodShipPatientAllCurrent


/****** Object:  View [dbo].[vw_BloodShipPatientAllCurrent]    Script Date: 5/8/2015 9:44:03 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE VIEW [dbo].[vw_BloodShipPatientAllCurrent]  
/*******************************************************************************************************************************************************************************
**	Name: 	vw_BloodShipPatientAllCurrent  
**
**	Desc: 	Replacement for view vw_BloodUnitsWithCurrentStatus which had poor performance
**
**
**	Author:	
**
**	Date:   	06/15/2005
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	---------	------			-----------------
**	06/27/2005				Modified DirectedPatientGUID to use function as was in original view, missed this
**	06/28/2005				Modified unitstatuscode to use data from bloodUnit Table rather than caluclated field from the table BloodUnitStatus
**	09/07/2005				Replaced subquery with TOP 1 to BloodUnitShipment with a JOIN to BloodUnitCurrentShipment to 
**								increase performance
**	10/03/2005				Removed CASE statement for DirectedPatientGuid; changed LEFT OUTER join to Patient to select either 
**								the FinalMergeToPatient if the patient has one or more merges (choosing the final merge record) or simply 
**								the patient guid if there are none; changed formatting slightly for readibility; removed unused code
**	10/04/2005				Removed function call using calculated column in table instead BUS.UnitStatusCode
**	10/13/2005				Added comments regarding the strange join on LocalSupplier
**	01/23/2006	     			** Reviewed for compliance with database standards and recommendations **
**	03/07/2006				Adding DiscardedPlasmaVolume for BloodAvailablilityReport
**	03/09/2006				Adding PendingTransferIndicator to help determine if unit is in "final" status
**	01/04/2010		     		Changed to get UnitStatusCode from the BloodUnitStatusCodeCurrent table. (CR 1174)
**	01/21/2010				** Reviewed for compliance with database standards and recommendations **
**	05/06/2015				CR3558 - adding new field ProductType.AboRhConfirmationRequired - format cleanup
**	05/08/2015				** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
AS
	
SELECT   
	BU.BloodUnitGuid,
	BU.UnitProductCode,
	BU.OriginalVolume,
	BU.UnitInDate,
	BU.UnitFdaRegistrationNumber,
	BU.UnitContainerLotNumber,
	BU.UnitDivisionId,
	BU.LabelTypeCode,
	BU.LabelUnitId,
	BU.EyeReadableUnitId,
	BU.BloodProductGuid,
	BU.DivisionCode,
	BU.ProcessingTechId,
	BU.RecordStatusCode,
	BU.LastUpdateDate,
	BU.LastUpdateUser,
	BU.[RowVersion],
	BU.LastUpdateFunctionId,
	BU.DiscardedPlasmaVolume,
	CURSHIP.IncomingShipmentGuid,
	CURSHIP.OutgoingShipmentGuid,
	BUM.BloodTypeCode,
	BUM.RhFactorCode,
	RH.RhFactorText,
	BUM.UnitExpirationDate,
	BUM.TestingStatusId,
	P.PatientGuid AS DirectedPatientGUID,
	BUM.Comments,
	BP.ProductName,
	BP.ProductShortName,
	BP.ProductTypeCode,
	BP.ProductAttributeForm,
	BP.ProductCode,
	BP.MaximumStorageTime,
	BP.CrossmatchRequiredIndicator,
	DT.DonationTypeId,
	DT.DonationTypeCode,
	DT.DonationTypeText,
	PT.ProductTypeName,
	PT.ComponentClassId,
	PT.SplitAllowedIndicator,
	Ship.ShipmentGuid,
	Ship.LocalSupplierGuid,
	Ship.InvoiceNumber,
	Ship.ShipmentDate,
	BUS.BloodUnitStatusGuid,
	BUSCC.UnitStatusCode,
	BUS.UnitStatusComments,
	BUS.DiscardCannedCommentGuid,
	BUS.BiohazardousWarningIndicator,
	BUS.QuarantineIndicator,
	ISNULL(BUS.PresumedTransfusedIndicator, 0) AS PresumedTransfusedIndicator,
	LS.FacilityName,
	LS.FdaRegistrationNumber,
	 LS.FacilityPrefix,
	LS.LabelUnitIdTrimIndicator,
	BUS.RowVersion AS UnitStatusRowVersion,
	US.UnitStatusText,
	/*Patient Data */
	P.PatientFirstName, 
	P.PatientMiddleName, 
	P.PatientLastName, 
	P.VistaPatientId, 
	P.PatientSsn, 
	P.DisplayVistaPatientId,
	P.PatientGUID,
	dbo.fnIsUnitPendingTransfer(BU.BloodUnitGuid) AS PendingTransferIndicator,
	PT.AboRhConfirmationRequired	--CR3558

	FROM
		dbo.BloodUnit BU
	INNER JOIN
		dbo.BloodUnitCurrentShipment CURSHIP ON BU.BloodUnitGuid = CURSHIP.BloodUnitGuid
	LEFT OUTER JOIN
		dbo.BloodUnitMedia BUM ON BU.BloodUnitGuid = BUM.BloodUnitGuid
	INNER JOIN
		dbo.BloodProduct BP ON BU.BloodProductGuid = BP.BloodProductGuid
	INNER JOIN
		dbo.DonationType DT ON BU.DonationTypeId = DT.DonationTypeId
	INNER JOIN
		dbo.ProductType PT ON BP.ProductTypeCode = PT.ProductTypeCode
	INNER JOIN
		dbo.Shipment Ship ON CURSHIP.IncomingShipmentGuid = Ship.ShipmentGuid
	LEFT OUTER JOIN
		dbo.BloodUnitStatus BUS ON BU.BloodUnitGuid = BUS.BloodUnitGUID
 	JOIN
		dbo.BloodUnitStatusCodeCurrent BUSCC ON BU.BloodUnitGuid = BUSCC.BloodUnitGuid
	INNER JOIN
		dbo.UnitStatus US ON BUSCC.UnitStatusCode = US.UnitStatusCode 
/* Per Cameron Taylor:
"When blood comes in, there are two facilities that we need to know about - the facility that shipped the unit, which we get from Shipment via the IncomingShipmentGuid.
The other is the collection facility, the facility that labelled the blood, this we get from FdaRegistrationNumber because that's what is on the bag*/
	LEFT OUTER JOIN
		dbo.LocalSupplier LS ON BU.UnitFdaRegistrationNumber = LS.FdaRegistrationNumber AND BU.DivisionCode = LS.DivisionCode
	INNER JOIN
		dbo.RhFactor RH ON BUM.RhFactorCode = RH.RhFactorCode
	-- This will return the most recent patient data, regardless of how many times the patient has been merged (most likely zero times).
	LEFT OUTER JOIN
		dbo.Patient LinkPatient ON BUM.DirectedPatientGuid = LinkPatient.PatientGuid
	LEFT OUTER JOIN	
		dbo.Patient P ON P.PatientGuid = COALESCE(LinkPatient.FinalMergeToPatient, LinkPatient.PatientGuid)
	
	WHERE     
		(BU.RecordStatusCode !='E' AND BU.RecordStatusCode !='X')



GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetLimitedBloodUnit]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetLimitedBloodUnit]
GO

/****** Object:  StoredProcedure [dbo].[spGetLimitedBloodUnit]    Script Date: 5/8/2015 3:39:47 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO


/*******************************************************************************************************************************************************************************
**	Desc: 	Selects blood units with a 'Limited' status for an invoice
**
**	Author: 	     	
**	Date: 	9/24/2002
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name			Description
**	---------	-----------		-----------------------------------------------------------
**	06/17/2003				Commented Assigned Name and SSN and Specimen Exp. Date to compile
**	8/12/03					Added UnitLotContainerNumber & IncomingShipmentGUID after it was added to vw_BloodUnitsWithCurrentStatus
**	11/04/2003				Added BloodProductGUID - needed by Worklistbuilder for UC2 to build a BloodUnit by DataRow
**	11/05/2003				Added the ProductTypeCode check as designated by BR_??
**	11/07/2003				Adding LabelTypeCode for WorkListBuilder
**	11/12/03				Added AboRh for WorkListBuilder
**	12/16/03				Added RTRIM to BloodTypeCode.  It's a 2char field, we want no spaces for A, B, O. -- it screws us UC5 filter
**	01/13/2004				Added DisplayVistaPatientId
**	04/27/2004				Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	01/20/2005				Changed to DiscardDetailCode DiscardCannedCommentGuid
**	02/08/2005				Adding Rhnegatvie parameter to filter negative units , BiohazardousWarningIndicator
**	04/08/2005				Adding @allowallunitstatus parameter - to allow selection of already confirmed units for BR_2.42
**	04/12/2005				Adding logic for BR2.04 - don't allow units already on another worklist (inprogress)
**	05/31/2005				Adding logic for BR11_04 - dont' allow units on a outgoing shipment (unconfirmed)
**	06/17/2005				Modified to use new view for increased performance
**	07/11/2005				Adding new product types (52-54) for BR_2.07 change
**	07/15/2005				** Reviewed for compliance with database standards and recommendations **
**								Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**								NOTE: The following are hardcoded:  BloodTestTypeId ,ProductTypeCode,UnitStatusCode, RhFactorCode consider using subquery instead
**	07/11/2005				Adding new product types (52-54) for BR_2.07 change
**	08/19/2005				Implemented differences between Review_Start and DEV before porting changes to DEV
**	08/30/2005				Replaced list of product codes with reference to component class ID in WHERE clause (for RBC and whole blood)
**	03/09/2006				Swapped PendingTransfer logic to use PendingTransferIndicator now being returned in vw_BloodShipPatientAllCurrent
								Reformatting IN CLAUSES to improve performance
**	05/25/2006				Adding UnitDivisionId in order to display FullproductCode to user
**	05/06/2015				CR3558 - Replacing WHERE RBC/WB check to determine LIMITED units with new PT.AboRhConfirmationRequired column, format fixes
**	05/08/2015				** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetLimitedBloodUnit]
(
	@shipmentguid	  	UNIQUEIDENTIFIER = NULL,
	@divisioncode		CHAR(5),
	@allownegativerh	BIT,
	@allowallunitstati	BIT
)

AS
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT

		BloodUnitGUID,
		EyeReadableUnitID,
		DirectedPatientGuid,
		UnitProductCode,
		RhFactorCode,

		UnitDivisionId,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) AS  UnitExpirationDate,
		DonationTypeID,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate) AS  UnitInDate,
		DivisionCode,

		BloodTypeCode,
		UnitFdaRegistrationNumber,
		LabelUnitID,
		ProductTypeCode,
		ProductName,

		ProductShortName,
		DonationTypeText,
		ProductTypeName,
		RhFactorText,
		FacilityName,

		PatientFirstName,
		PatientMiddleName,
		PatientLastName,
		MaximumStorageTime,
		VistaPatientID,

		PatientSSN,
		DisplayVistaPatientId,
		UnitStatusComments,
		DiscardCannedCommentGuid,
		UnitStatusCode,

		UnitStatusText,
		QuarantineIndicator,
		BiohazardousWarningIndicator,
		TestingStatusId,
		OriginalVolume,

		[RowVersion],
		Comments,
		RTRIM(BloodTypeCode) + ' ' + RhFactorText AS AboRh,
		UnitContainerLotNumber,
		IncomingShipmentGUID,

		BloodProductGUID,
		LabelTypeCode,
		PendingTransferIndicator

	FROM

		dbo.vw_BloodShipPatientAllCurrent

	WHERE

	 	((@allowallunitstati = 0 AND UnitStatusCode = 'L') OR 
		(@allowallunitstati = 1 AND (UnitStatusCode = 'L' OR UnitStatusCode = 'A' OR UnitStatusCode = 'S' OR UnitStatusCode = 'C')))

	AND	AboRhConfirmationRequired = 1 --CR3558

	AND	((@allownegativerh = 0  AND RhFactorCode != 'N') OR (@allownegativerh = 1))

	AND	DivisionCode = @divisioncode

	AND	((@shipmentguid IS NOT NULL  AND IncomingShipmentGUID = @shipmentGuid) OR (@shipmentguid IS NULL))

	AND	PendingTransferIndicator = 0

	AND	((@shipmentguid IS NOT NULL AND BloodUnitGuid NOT IN (

					SELECT BloodUnitGuid FROM dbo.BloodUnitTest BUT WHERE DivisionCode = @divisioncode 

					AND RecordStatusCode = 'A' AND (BloodTestTypeId >= 15 AND BloodTestTypeId <=21)) OR (@shipmentguid IS NULL))

					)

	ORDER BY

		LastUpdateDate

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN (@ERROR)


GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetLimitedBloodUnitsByDivision]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetLimitedBloodUnitsByDivision]
GO


/****** Object:  StoredProcedure [dbo].[spGetLimitedBloodUnitsByDivision]    Script Date: 5/28/2015 11:49:37 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO


/*******************************************************************************************************************************************************************************
**	Desc: 	Selects blood units with a 'Limited' status for a division.
**
**	Author: 	     	
**	Date: 	2/7/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
** 	Date		Name			Description
**	---------	-----------		-----------------------	
**	06/16/03				Removed fields due to vw_BloodUnitsWithCurrentStatus having changed (changes denoted with --1 ) 
**	08/12/03				Added UnitContainerLotNumber after it was been added to vw_BloodUnitsWithCurrentStatus
**	10/07/03				Looks like UC2 is the only area in the app using this, so I tacked on another parameter (just in case) to limit the bloodunits based on producttype
**	11/04/03				Adding BloodProductGUID -- needed for building BloodUnit object using DataRow constructor
**	11/07/03				Adding LabelTypeCode for WorklistBuilder
**	12/16/03				Added RTRIM to BloodTypeCode.  It's a 2char field, we want no spaces for A, B, O. -- it screws up UC5 filter
**	01/13/2004				Added DisplayVistaPatientId
**	02/10/2004				Adding UnitDivisionId for ISBT alloQUAT search. Adding FullProductCode
**	04/27/2004				Call fnTimeZoneConversionDateTime function on all dates
**	09/14/2004				Added ShipmentDate, to be used instead of UnitInDate
**	12/03/2004				Added PresumedTransfusedIndicator
**	01/20/2005				Changed to DiscardDetailCode DiscardCannedCommentGuid
**	02/08/2005				Adding parameter to restrict data by RhFactor
**	04/11/2005				Changing ProductType to BIT
**	04/12/2005				Adding logic for BR_2.04 - don't allow units that are already on another worklist (inprogress)
**	05/31/2005				Adding logic for BR_11.04 - don't allow units that have been added to an outgoing shipment (confirmed or not)
**	06/17/2005				Changed to use new view to increase performance
**	07/11/2005				Adding new ProductTypes for BR_2.07 change
**	07/15/2005				** Reviewed for compliance with database standards and recommendations **
								Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
								NOTE: BloodTestTypeId,ProductTypeCode,UnitStatusCode,RhFactorCode are hard coded in the WHERE clause 
								consider using subqueries instead so if values change in table proc code does not have to be changed.
**	07/21/2005				Adding ORDER BY EyeReadableUnitId, FullProductCode
**	08/30/2005				Replaced list of product codes with reference to component class ID in WHERE clause (for RBC and whole blood)
**	03/09/2006				Swapped PendingTransfer logic to use PendingTransferIndicator now being returned in vw_BloodShipPatientAllCurrent
								redoing the IN clauses to increase performance
**	05/06/2015				CR3558 - Replacing WHERE RBC/WB check to determine LIMITED units with new PT.AboRhConfirmationRequired column, format fixes
**	05/08/2015				** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetLimitedBloodUnitsByDivision]
(
	@divisioncode		VARCHAR(5),
	@allowallproducttypes	BIT = 0,
	@allownegativerh	BIT
)
AS
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT

		BloodUnitGUID,
		EyeReadableUnitID,
		DirectedPatientGuid,
		UnitProductCode,
		RhFactorCode,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitExpirationDate) 					AS  UnitExpirationDate,

		DonationTypeID,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, UnitInDate)						 AS  UnitInDate,

		DivisionCode,
		BloodTypeCode,
		UnitFdaRegistrationNumber,
		LabelUnitID,
		ProductTypeCode,
		ProductName,
		ProductShortName,
		BiohazardousWarningIndicator,
		DonationTypeText,
		ProductTypeName,
		RhFactorText,
		FacilityName,
		PatientFirstName,
		PatientMiddleName,
		PatientLastName,
		MaximumStorageTime,
		VistaPatientID,
		PatientSSN,
		DisplayVistaPatientId,
		UnitStatusComments,
		DiscardCannedCommentGuid,
		UnitStatusCode,
		UnitStatusText,
		QuarantineIndicator,
		TestingStatusId,
		OriginalVolume,
		[RowVersion],
		Comments,
		IncomingShipmentGUID,
		RTRIM(BloodTypeCode) + ' ' + RhFactorText 									AS AboRh,
		UnitContainerLotNumber,
		BloodProductGUID,
		LabelTypeCode,
		UnitDivisionId,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, ShipmentDate) 						AS ShipmentDate,

		PresumedTransfusedIndicator,

		CASE LabelTypeCode

			WHEN 'I' THEN 

				UnitProductCode + DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + UnitDivisionId 

			ELSE 

				UnitProductCode

		END 														AS FullProductCode 

	FROM	

		dbo.vw_BloodShipPatientAllCurrent

	WHERE 

		DivisionCode = @DivisionCode

	AND	UnitStatusCode = 'L'

	AND	((@allownegativerh = 0  AND RhFactorCode != 'N') OR (@allownegativerh = 1))

	AND	((@allowallproducttypes = 0  AND AboRhConfirmationRequired = 1)	--CR3558

				OR (@allowallproducttypes = 1))

	AND	BloodUnitGuid NOT IN (

					SELECT BloodUnitGuid FROM dbo.BloodUnitTest BUT WHERE DivisionCode = @divisioncode AND RecordStatusCode = 'A' AND 

					(BloodTestTypeId >= 15 AND BloodTestTypeId <= 21)

					)
	AND	PendingTransferIndicator = 0
	AND BiohazardousWarningIndicator = 0	--CR945
	AND QuarantineIndicator = 0				--CR945

	ORDER BY

		EyeReadableUnitId, FullProductCode

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN (@ERROR)


GO




if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetBloodProductByGuid]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetBloodProductByGuid]
GO

/****** Object:  StoredProcedure [dbo].[spGetBloodProductByGuid]    Script Date: 5/8/2015 4:24:36 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO

/*******************************************************************************************************************************************************************************
**	Desc: 	Gets Blood Product information based on the blood product guid and division passed to the procedure.
**
**	Author:	
**
**	Date: 	10/3/2002
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	------		-------			-----------------
**	5/18/03			     		Added HcpcsCode
**	7/29/03					Removed HcpcsCode, not compiling
**	10/30/03				Added IFNULL check to HcpcsCode.
**	03/01/2004				Added row version to SELECT, commented out BP.RowVersion, not needed since BP cannot be updated
**	11/9/2004				Adding ComponentClassName
**	03/23/2005				Adding fnIsProductActive to replace DSP table drop
**	07/14/2005				** Reviewed for compliance with database standards and recommendations **
								Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, specified object owners
**	08/03/2005				Adding DivisionCode to HcpcsAssignment table join
**	05/06/2015				CR3558 - Adding new PT.AboRhConfirmationRequired column, format fixes
**	05/08/2015				** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetBloodProductByGuid]
(
	@bloodproductguid AS UNIQUEIDENTIFIER,
	@divisioncode AS CHAR(5)
)
AS
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON

	SELECT DISTINCT

		BP.BloodProductGUID,
		BP.ProductAttributeForm,
		PT.ComponentClassID,
		CC.ComponentClassName,
		BP.ProductCode,
		BP.ProductShortName,
		BP.ProductName,
		BP.ProductTypeCode,
		PT.ProductTypeName,
		BP.ProductVolume,
		BP.MaximumStorageTime,
		BP.ProductCodeIndicator 					AS BarcodeType,

		dbo.fnIsProductActive(BP.BloodProductGuid, @divisioncode) 	AS ProductActiveIndicator,

		ISNULL(HA.HcpcsCode,'') 					AS HcpcsCode,
		PT.AboRhConfirmationRequired	--CR3558
	
	FROM  	
		dbo.BloodProduct BP
	JOIN 
		dbo.ProductType PT ON BP.ProductTypeCode = PT.ProductTypeCode
	JOIN 
		dbo.ComponentClass CC ON PT.ComponentClassId = CC.ComponentClassId
	LEFT OUTER JOIN 
		dbo.HcpcsAssignment HA ON BP.BloodProductGUID = HA.BloodProductGUID
									AND	HA.UnAssignedDate IS NULL
									AND	HA.DivisionCode = @divisioncode
	WHERE
		BP.BloodProductGUID = @bloodproductguid


SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)

GO




if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetBloodProductByCode]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetBloodProductByCode]
GO


/****** Object:  StoredProcedure [dbo].[spGetBloodProductByCode]    Script Date: 5/8/2015 4:31:16 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO

/*******************************************************************************************************************************************************************************
**	Desc: 	Search BloodProduct table for matching entry
**
**	Author:	
**
**	Date: 	8/28/2002
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	---------	----			--------------
**	03/05/03			Added RowVersion
**	05/14/03	     		Added HcpcsCode and locking.
**	06/12/03		Added Top 1 to 'SELECT TOP 1 @RecordGUID = BloodProductGUID ' because there may be duplicate product codes
**	7/22/2003			Removed HcpcsCode (this was breaking the sproc)
**	8/12/2003			Added ProductAttributeForm
**	12/2/2003				Added RecordStatusCode to WHERE clause to only include valid producttypes
**	03/01/2004			Added row version to SELECT, commented out BP.RowVersion, not needed since BP cannot be updated
**	11/09/2004				Adding ComponentClassName
**	03/23/2005				Adding fnIsProductActive to replace DSPtable  drop
**	07/14/2005			** Reviewed for compliance with database standards and recommendations **
								Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
								Added brackets around input parameters, Changed RecordStatusCode IN ('A') to RecordStatusCode = 'A' 
**	08/03/2005				Adding divisioncode to Hcpcs table join
**	08/19/2005			Implemented differences between Review_Start and DEV before porting changes to DEV
**	05/06/2015				CR3558 - Adding new PT.AboRhConfirmationRequired column, format fixes
**	05/08/2015			** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodProductByCode]
(
	@productcode 		VARCHAR (5),
	@divisioncode 		CHAR (5)
)

AS
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR INT

SET NOCOUNT ON
	
	SELECT

		BP.BloodProductGUID,
		PT.ComponentClassID,
		CC.ComponentClassName,
		BP.ProductCode,
		BP.ProductShortName,
		BP.ProductName,
		BP.ProductTypeCode,
		PT.ProductTypeName,
		BP.ProductVolume,
		BP.MaximumStorageTime,
		BP.ProductCodeIndicator 					AS BarcodeType,

		dbo.fnIsProductActive(BP.BloodProductGuid, @divisioncode) 	AS ProductActiveIndicator,

		ISNULL(HA.HcpcsCode,'') 					AS HcpcsCode,
		BP.ProductAttributeForm,
		PT.AboRhConfirmationRequired	--CR3558
	
	FROM	
		dbo.BloodProduct BP
	JOIN 
		dbo.ProductType PT ON BP.ProductTypeCode = PT.ProductTypeCode
	JOIN 
		dbo.ComponentClass CC ON CC.ComponentClassId = PT.ComponentClassId
	LEFT OUTER JOIN 
		dbo.HcpcsAssignment HA ON BP.BloodProductGUID = HA.BloodProductGUID
									AND	HA.UnAssignedDate IS NULL
									AND	HA.DivisionCode = @divisioncode
	WHERE
		BP.ProductCode = @productcode
	AND	BP.RecordStatusCode = 'A' 
	
SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)

GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetDailyQCRacks]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetDailyQCRacks]
GO

/****** Object:  StoredProcedure [dbo].[spGetDailyQCRacks]    Script Date: 5/8/2015 4:49:00 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO

/*******************************************************************************************************************************************************************************
**	Desc: 	Get the list of racks for daily QC
**
**	Author: 	
**
**	Date: 	01/06/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	------------		---------			------------------
**	01/06/2003		Initial creation.
**	04/21/2004			Call fnTimeZoneConversionDateTime function on all dates
**	07/17/2005 			** Reviewed for compliance with database standards and recommendations **
**						NO COUNT set OFF; comments updated; capitalized SQL statements;
**						removed unused code			
**	08/19/2005		Specified object owners, aliased tables
**	11/04/2009		Added QCOfflineIndicator (CR 2718)
**	08/18/2010		** Reviewed for compliance with database standards and recommendations **
**  04/23/2015	Removed time zone conversion from JOIN and replaced it with variable (CR 3563)
**	05/08/2015			** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetDailyQCRacks]
(
	@divisioncode			VARCHAR(5),
	@testdatetime			DATETIME
)

AS

SET NOCOUNT ON

SET @testdatetime = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @testdatetime) 

	SELECT
		R.RackGuid,
		R.RackName,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, DCW.DailyQcExpirationDate) AS DailyQcExpirationDate,
		DCW.DailyQcWorklistGuid,
		DCW.PartiallyTestedIndicator,
		DCW.DailyUseIndicator,
		DCW.QCOfflineIndicator,
		DCW.[RowVersion],
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, DCW.LastUpdateDate) AS LastUpdateDate,
		R.DivisionCode,
		R.LastUpdateUser,
		DC.DailyControlGuid,
		DC.RackNamesIndicator,
		DC.CommercialTemplateIndicator,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, DC.DailyAlertTime) AS DailyAlertTime

   	FROM dbo.Rack R

	JOIN dbo.DailyControl DC ON R.DailyControlGUID = DC.DailyControlGuid

	LEFT JOIN dbo.DailyQcWorklist DCW ON DCW.RackGuid = R.RackGuid 
		AND ( ((DATEDIFF(SECOND, @testdatetime, DCW.DailyQcExpirationDate) <= 86400) 
			AND (DATEDIFF(SECOND, @testdatetime, DCW.DailyQcExpirationDate) >= -0)) )
		AND DCW.RecordStatusCode = 'A'
	WHERE
		DC.DivisionCode = @divisioncode
	AND
		DC.RecordStatusCode = 'A'
	AND
		R.RecordStatusCode = 'A'
	
	ORDER BY R.SortColumn, DCW.DailyQcExpirationDate

RETURN (@@ERROR)

SET NOCOUNT OFF

GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetReagentLotsForRetest]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetReagentLotsForRetest]
GO

/****** Object:  StoredProcedure [dbo].[spGetReagentLotsForRetest]    Script Date: 5/8/2015 4:54:52 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO

/*******************************************************************************************************************************************************************************
**	Desc: 	Get the list of reagent lot numbers for retested rack
**
**	Author: 	
**
**	Date: 	01/16/2003
**
*******************************************************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-------------------	-----------------------	------------------------------------------------------------------------------------------------------------------------------------------------------------------------
**	01/16/2003		Initial creation.
**	04/21/2004			Call fnTimeZoneConversionDateTime function on all dates; Added divisioncode
**	07/07/2005		** Reviewed for compliance with database standards and recommendations **
**					Removed name, input/output from comment header, Added NOCOUNT, Specified table owners, spaced out SQL,
					Aliased table names
**	04/23/2015		Modified WHERE clause to take only the last set of QC results instead of all of them (CR 3563)
**	05/08/2015			** Reviewed for compliance with database standards and recommendations **
*******************************************************************************************************************************************************************************/

CREATE PROCEDURE [dbo].[spGetReagentLotsForRetest]
(
	@rackguid			UNIQUEIDENTIFIER,
	@divisioncode			CHAR(5)
)
	
 AS

DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

	SELECT

		RE.ReagentGUID,
		RE.LotNumber,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, RE.LotExpirationDate) AS  LotExpirationDate,

		RE.ReagentTypeID,
		RE.InspectionIndicator,
		RT.ReagentTypeName,
		RE.ReagentManufacturerName,

		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, RL.LastUpdateDate) AS  LastUpdateDate,

		RL.TestWithName,
		TM.TestingMethodText
	
	   FROM 

		dbo.Reagent RE
	
		JOIN
			dbo.RackLot RL ON RL.ReagentGUID = RE.ReagentGUID
		JOIN
			dbo.Rack R ON R.RackGUID = RL.RackGUID
		JOIN
			dbo.ReagentType RT ON RT.ReagentTypeID = RE.ReagentTypeID
		JOIN
			dbo.TestingMethod TM ON TM.TestingMethodCode = RL.TestingMethodCode
	
	WHERE

		R.RackGUID = @rackguid
	AND
		RL.LastUpdateDate = (SELECT MAX(LastUpdateDate) FROM dbo.RackLot WHERE RackLot.RackGuid = @rackguid)

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN (@ERROR)

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetOrderedUnitByPatientAndUnit]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetOrderedUnitByPatientAndUnit]
GO

/****** Object:  StoredProcedure [dbo].[spGetOrderedUnitByPatientAndUnit]    Script Date: 5/8/2015 5:00:25 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO

/*****************************************************************************************************************
**	Desc:	Gets all Ordered Unit based on patient and unit
**
**	Author:	
**
**	Date: 	4/15/2004
**
******************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	--------------------	-----------------------	----------------------------------------------------------------------------------------------------------------------------------------------------
**	04/16/2004		Added RecordStatusCode
**	04/23/2004		Call fnTimeZoneConversionDateTime function on all dates
**	05/25/2004		Added SelectedDate and SelectedTechId
**	06/07/2004		Replaced PatientGuid clause with fnWherePatientGuid function, to include possible merged patients
**	10/27/2004		Added CrossmatchTechID
**	02/01/2005			Adding BloodUnitGuid, DivisionCode for UC 24-26
**	03/28/2005		Added TimeZone conversion to OU.SelectedDate
**	07/20/2005		** Reviewed for compliance with database standards and recommendations **
**					Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, specified object owners
**	07/25/2005			Adding ReleaseDate, ReleaseTechId			
**	09/09/2005		Removed fnWherePatientGuid via sub-query using new PatientMergeGroup
**	10/13/2010	      	Changed the input parameter to allow multiple blood unit guids.  (CR 2899)
**	12/22/2010		** Reviewed for compliance with database standards and recommendations **
**  02/04/2015		Added SpecimenExpirationDate. (CR 3565)
**	05/08/2015			** Reviewed for compliance with database standards and recommendations **
******************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetOrderedUnitByPatientAndUnit]
(
	@patientguid		UNIQUEIDENTIFIER,
	@bloodunitguidlist	VARCHAR(8000),  -- Allows multiple copies of (38-character guid + 1-char delimiter)
	@divisioncode		CHAR(5)
)
AS


SET NOCOUNT ON
		
    SELECT DISTINCT

	OU.BloodUnitGuid,
	OU.DivisionCode,
	OU.OrderedUnitGUID,
	OU.CrossmatchRequiredIndicator,

	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, OU.SelectedDate ) AS SelectedDate,

	OU.SelectedTechId,

	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, OU.CrossmatchDate ) AS CrossmatchDate,

	OU.CrossmatchResultCode,
	OU.CrossmatchTechID,
	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, OU.ReleaseDate ) AS ReleaseDate,
	OU.ReleaseTechId,
	OU.RecordStatusCode,
	OU.OrderedComponentGUID,
	PT.PatientLocation,
	PS.Specimenuid,
	dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PS.SpecimenExpirationDate ) AS SpecimenExpirationDate,
	CR.CrossmatchResultText,
	OU.LastUpdateUser,
	OU.[Rowversion]

    FROM 

	dbo.OrderedUnit OU
		JOIN dbo.fnSplit(@bloodunitguidlist, ',')
			ON OU.BloodUnitGuid = Item

   	JOIN dbo.OrderedComponent OC ON OC.OrderedComponentGUID = OU.OrderedComponentGUID

    	JOIN dbo.ComponentClassParameter CCC ON OC.ComponentClassID = CCC.ComponentClassID AND OC.DivisionCode = CCC.DivisionCode

   	JOIN dbo.PatientOrder PO ON OC.PatientOrderGUID = PO.PatientOrderGUID

    	JOIN dbo.PatientTreatment PT ON PT.PatientTreatmentGUID = PO.PatientTreatmentGUID

	LEFT JOIN dbo.CrossmatchResult CR ON OU.CrossmatchResultCode = CR.CrossmatchResultCode

	LEFT JOIN dbo.PatientSpecimen PS on OC.PatientSpecimenGUID = PS.PatientSpecimenGUID

    WHERE 

	PT.PatientGUID IN 
	(
		SELECT 
			P.PatientGuid
		FROM
			dbo.Patient P
		JOIN 
		    	dbo.Patient LinkPatient ON  P.PatientMergeGroup = LinkPatient.PatientMergeGroup OR P.PatientGuid = LinkPatient.PatientGuid
		WHERE
			LinkPatient.PatientGuid = @patientguid
	)

	AND OU.ReleaseDate IS NULL


SET NOCOUNT OFF

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spDeleteVbecsLock]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spDeleteVbecsLock]
GO


/****** Object:  StoredProcedure [dbo].[spDeleteVbecsLock]    Script Date: 5/11/2015 8:38:41 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO

/************************************************************************************************************
**	Desc: 	Removes a row from the vbecsLock table
**
**	Author:	
**
**	Date: 	08/20/2003
**
*************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	---------	----------		-----------
**	3/12/2013				VBECS 2.0 refactor
**	09/12/2013				CR3311 - corrections to how DivisionCode is treated in WHERE clauses
								if DivisionCode is NULL, then MultiDivisional must be true, otherwise they must equal
**	10/01/2013		**	Reviewed for compliance with database standards and recommendations **
**	05/08/2015				CR3555 = replaced check (= NULL) with (IS NULL) to utilize ANSI_NULLS ON
**	05/11/2015		**	Reviewed for compliance with database standards and recommendations **
*************************************************************************************************************/
CREATE PROCEDURE [dbo].[spDeleteVbecsLock]
(
	@lockedrecordguid	UNIQUEIDENTIFIER = NULL,
	@lockedusecaseid	INT = NULL,
	@lockedformid		INT, 
	@lockfunctionid		INT = NULL,
	@lastupdateuser		VARCHAR(30),
	@lastupdatedate		DATETIME = NULL ,
	@divisioncode		CHAR(5)  = NULL,
	@sessionguid		UNIQUEIDENTIFIER = NULL,
	@baselockedformid	INT = NULL
)

AS

DECLARE @ERROR INT

SET NOCOUNT ON

	IF (@lockedrecordguid IS NULL)		-- We want to delete all Lock for a UC/Form  ..UnlockAllRecordsForUseCaseUser()

		BEGIN
	
			DELETE FROM
	
				dbo.VBECSLock
	
			WHERE
	
				(LockFunctionID = @lockfunctionid
	
			AND	LockedFormId = @lockedformid 
	
			AND	LastUpdateUser = @lastupdateuser

			AND	((@divisioncode IS NULL AND MultiDivisionIndicator = 1) OR (@divisioncode IS NOT NULL AND DivisionCode = @divisioncode))

			AND 	((@sessionguid IS NULL) OR (@sessionguid IS NOT NULL AND SessionGuid = @sessionguid))
			     )

			OR
			(	
					SessionGuid = @sessionguid 
				AND BaseLockedFormId = @baselockedformid 
				AND LastUpdateUser = @lastupdateuser 
				AND ((@divisioncode IS NULL AND MultiDivisionIndicator = 1) OR (@divisioncode IS NOT NULL AND DivisionCode = @divisioncode)))

		END



	ELSE 

		BEGIN	
		IF (@lockfunctionid IS NULL)	--@lockfunctionid is missing but @lockedrecordguid has a value
			BEGIN

				DELETE FROM	dbo.VbecsLock
				WHERE
						LockedRecordGUID = @lockedrecordguid
				AND		((@divisioncode IS NULL AND MultiDivisionIndicator = 1) OR (@divisioncode IS NOT NULL AND DivisionCode = @divisioncode))
				AND 	((@sessionguid IS NULL) OR (@sessionguid IS NOT NULL AND SessionGuid = @sessionguid))

			END
		ELSE		--LockFunctionId has a value

			BEGIN
			
				DELETE FROM	dbo.VbecsLock
				WHERE
						LockedRecordGUID = @lockedrecordguid
				AND		LockedFormId = @lockedformid
				AND		LockFunctionID = @lockfunctionid
				AND		LastUpdateUser = @lastupdateuser
				AND		((@divisioncode IS NULL AND MultiDivisionIndicator = 1) OR (@divisioncode IS NOT NULL AND DivisionCode = @divisioncode))
				AND 	((@sessionguid IS NULL) OR (@sessionguid IS NOT NULL AND SessionGuid = @sessionguid))

			END

		END

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetBloodAvailabilityItems]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetBloodAvailabilityItems]
GO


/****** Object:  StoredProcedure [dbo].[spGetBloodAvailabilityItems]    Script Date: 5/11/2015 8:56:08 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO

/************************************************************************************************************
**	Desc: 	Get Blood Unit Items for the Blood Availability Report
**
**	Author: 
**
**	Date:   03/10/2004
**
*************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	-----------	---------		------------------
**	4/19/04				Replaced PatientSSN with DisplayVistaPatientId and added TestingStatusText, QurantineIndicator and Biohazardous indicator
**	03/29/2005				Added RecordStatusCode to BloodUnitModification table join
**	05/26/2005				PooledUnitsCount is now a function.
**	07/14/2005			** Reviewed for compliance with database standards and recommendations **
**								Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL, 
**								Specified object owners in SQL
**								Using EXEC and dynamic SQL for a dynamic WHERE clause, consider using this approach instead:
**								WHERE Cus_Name = COALESCE(@Cus_Name,Cus_Name) AND
**									Cus_City = COALESCE(@Cus_City,Cus_City) AND
**									Cus_Country = COALESCE(@Cus_Country,Cus_Country)
**								SQL CODE IS SIMILAR TO THE OTHER "GETBLOODAVAILABILITY" PROCEDURES, CONSIDER USING A COMMON VIEW
**
**	07/28/2005			Cannot modify this SP in a manner similar to the other "spGetBloodAvailibility..." procedures because the dynamic SQL statement
**								is larger than 4000 characters, which is the limit for an NVarChar type.  NVarChar type is necessary in order to call spexecsql.
**								Modified to join on vw_BloodUnitsWithAntigensIdentified instead of fnGetUnitsWithAntigensIdentified().
**
**	08/19/2005			Implemented differences between Review_Start and DEV before porting changes to DEV
**								NOTE: Do not remove joins to the following tables
**								that are already joined in the main view: BloodUnitStatus, Dontationtype, Patient, shipment as these are required and expected by the dynamic WHERE feature
**
**	08/22/2005			Missing FROM in dynamic SQL
**	10/05/2005			Added ProductType join to identify modifications using ProductTypePrintName
**	01/17/2006			Added FullProductCode (UnitProductCode, DonationTypeCode, UnitDivisionId) to ProductShortName (DR 1729)
**	01/22/2006	    			** Reviewed for compliance with database standards and recommendations **
**	05/08/2015				CR3555 - replaced (= NULL) with (IS NULL) to utilize ANSI_NULLS = ON, formating
**	05/11/2015			**	Reviewed for compliance with database standards and recommendations **
*************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetBloodAvailabilityItems]
	--This parameter should contain the string to filter the data.
	--The number of parameters is dynamic and we never know exactly how many 
	--there are going to be so we need to make a long string of comparisons.
(
	@WhereClause	NVARCHAR(4000),
	@divisioncode	VARCHAR(5)
)
AS
/*	@ERROR VARIABLE  USED BECAUSE SET NOCOUNT OFF RESETS THE @@ERROR TO ZERO 	*/
DECLARE @ERROR		INT

SET NOCOUNT ON
--Query String that will be executed at the end.
DECLARE @QUERY		varchar(8000)
DECLARE @WHERE		varchar(8000)

SET @QUERY='
	SELECT
		DISTINCT b.BloodUnitGuid,
		(SELECT 
			v.DivisionName 
		FROM 
			VamcDivision v 
		WHERE 
			v.DivisionCode=b.DivisionCode
		) as DivisionName,
		b.DivisionCode,
		b.EyeReadableUnitId,
		CASE b.LabelTypeCode
			WHEN ''I'' THEN b.ProductShortName+'', ''+b.UnitProductCode + b.DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + b.UnitDivisionId 
			ELSE b.ProductShortName+'', ''+b.UnitProductCode
		END AS ProductShortName,
		dbo.fnGetPooledUnitsCount(b.BloodUnitGuid) AS PooledUnitsCount,
		b.BloodTypeCode,
		bt.SortColumn as ABOSortColumn,
		b.RhFactorCode,
		rh.SortColumn as RhSortColumn,
		dbo.fnTimeZoneConversionDateTime('''+@divisioncode+''', 0, b.UnitExpirationDate) AS  UnitExpirationDate,
		(CASE 
			dt.RestrictionTypeCode
		WHEN 
			''N'' THEN ''Allogeneic'' 
		WHEN 
			''A'' THEN ''Autologous'' 
		ELSE 
			''Directed'' 
		END
		) as DonationTypeCode,
		b.UnitStatusText,
		us.SortColumn as UnitStatusSortColumn,
		b.BiohazardousWarningIndicator,
		b.QuarantineIndicator,
		b.DirectedPatientGuid,
		b.PatientLastName as DirectedPatientLastName,
		b.PatientFirstName as DirectedPatientFirstName,
		b.PatientMiddleName as DirectedPatientMiddleName,
		ts.TestingStatusText,
		(SELECT
			iu.IssueToLocationName 
		FROM
			IssuedUnit iu 
		WHERE 
			iu.BloodUnitGuid=b.BloodUnitGuid 
		AND
			iu.ReturnDateTime IS NULL
		) as IssueToLocationName,
		cc.ComponentClassName as ComponentClassId,
		cc.SortColumn as ComponentClassSortColumn
	FROM	dbo.vw_BloodShipPatientAllCurrent b
	JOIN
		dbo.BloodType bt ON bt.BloodTypeCode= b.BloodTypeCode
	JOIN
		dbo.RhFactor rh ON 	rh.RhFactorCode=b.RhFactorCode	
	JOIN
		dbo.BloodUnitStatus s ON s.BloodUnitStatusGuid = b.BloodUnitStatusGuid	
	JOIN
		dbo.UnitStatus us ON us.UnitStatusCode=b.UnitStatusCode
	LEFT OUTER JOIN
		dbo.BloodUnitModification d ON b.BloodUnitGuid=d.FromBloodUnitGuid AND d.RecordStatusCode = ''A''
	LEFT OUTER JOIN
		dbo.vw_BloodUnitsWithAntigensIdentified a ON b.BloodUnitGuid=a.BloodUnitGuid			
	LEFT OUTER JOIN
		dbo.BloodUnitTest t ON b.BloodUnitGuid=t.BloodUnitGUID
	JOIN
		dbo.ComponentClass cc ON cc.ComponentClassId=b.ComponentClassId
	JOIN
		dbo.ProductType pt ON pt.ProductTypeCode=b.ProductTypeCode
	LEFT OUTER JOIN
		dbo.DonationType dt ON b.DonationTypeId=dt.DonationTypeID
	LEFT OUTER JOIN
		dbo.TestingStatus ts ON b.TestingStatusId = ts.TestingStatusId
	LEFT OUTER JOIN 
		dbo.OrderedUnit ou on b.BloodUnitGuid = ou.BloodUnitGuid AND ou.ReleaseDate IS NULL AND ou.RecordStatusCode = ''A'' AND ou.DivisionCode = b.DivisionCode
	LEFT OUTER JOIN 
		dbo.OrderedComponent oc on oc.OrderedComponentGuid = ou.OrderedComponentGuid 
	LEFT OUTER JOIN 
		dbo.PatientOrder po on po.PatientOrderGuid = oc.PatientOrderGuid 
	LEFT OUTER JOIN 
		dbo.PatientTreatment ptt on ptt.PatientTreatmentGuid = po.PatientTreatmentGuid
	LEFT OUTER JOIN 
		dbo.Patient pat on pat.PatientGuid = ptt.PatientGuid
	LEFT OUTER JOIN
		dbo.Shipment os on os.ShipmentGuid = b.OutgoingShipmentGuid AND os.ShipmentDate IS NOT NULL'

SET @WHERE='
	WHERE
		'+@WhereClause+'
		AND b.RecordStatusCode = ''A'' 
	ORDER BY
		DivisionName, ComponentClassSortColumn, ABOSortColumn, RhSortColumn, UnitStatusSortColumn, ProductShortName, UnitExpirationDate, EyeReadableUnitId'

EXEC(@QUERY+@WHERE)

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN (@ERROR)
GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetHcpcsAssignmentHistory]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetHcpcsAssignmentHistory]
GO

/****** Object:  StoredProcedure [dbo].[spGetHcpcsAssignmentHistory]    Script Date: 5/11/2015 9:18:03 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO

/************************************************************************************************************
**	Desc: 	Selects all Hcpcs assignment history for a given BloodProduct
**
**	Author:	
**
**	Date: 	8/06/2003
**
*************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	--------	---------		---------------------------------
**	04/27/2004		Call fnTimeZoneConversionDateTime function on all dates
**	07/20/2005			** Reviewed for compliance with database standards and recommendations **
**								Removed Name/input/output from comment header, added SET NOCOUNT, formatted SQL
**
**	07/25/2005				Adding HcpcsAssignmentGuid, RowVersion, BloodProductGuid fields -- for spUpdateHcpcsAssignmentHistory
**	05/08/2016				CR3555 - replacing (= NULL) with (IS NULL) to utilize ANSI_NULLS = ON, formating
**	05/11/2015			**	Reviewed for compliance with database standards and recommendations **
*************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetHcpcsAssignmentHistory]
(
	@bloodproductguid	UNIQUEIDENTIFIER,
	@divisioncode		CHAR(5)
)

AS

DECLARE @ERROR INT
DECLARE @_maxdate DATETIME 

SET @_maxdate = CONVERT(DATETIME, '12/31/9999', 101)

SET NOCOUNT ON

	SELECT

		HcpcsAssignmentGuid,
		BloodProductGuid,
		Hcpcscode,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, AssignedDate)  	AS AssignedDate,

		CASE WHEN UnAssignedDate IS NULL THEN @_maxdate
		ELSE
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0,  UnAssignedDate)
		END	AS UnAssignedDate,

		[RowVersion]

	FROM
		dbo.HcpcsAssignment
	WHERE
		BloodProductGUID = @bloodproductguid
	AND	DivisionCode	= @divisioncode
	
	ORDER BY
		AssignedDate DESC, UnAssignedDate DESC

SET @ERROR = @@ERROR

SET NOCOUNT OFF

RETURN(@ERROR)
GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spInactivateOrderedTestResults]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spInactivateOrderedTestResults]
GO

/****** Object:  StoredProcedure [dbo].[spInactivateOrderedTestResults]    Script Date: 5/11/2015 10:47:04 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO

/**********************************************************************************************************************
**	Desc: 	Inactivates test results for the ordered test
**
**	Author: 	
**
**	Date: 	06/25/2003
***********************************************************************************************************************
**	Modified:
**	Date		Name				Description
**	----------	---------			------------------
**	06/25/2003			Initial creation.
**	10/14/2003			Added Division Code
**	01/30/3004			Added row version parameter.
**	04/28/2004			Call fnTimeZoneConversionDateTime function on all dates
**	01/10/05				Added @lastupdatedate
**	06/29/2005				** Reviewed for compliance with database standards and recommendations **
**									Comment Header Adjusted, Added NOCOUNT, Specified table owners, Removed comments
**
**	05/08/2015					CR3555 - replacing (<> NULL) with (IS NOT NULL) to utilize ANSI_NULLS = ON, formating
**	05/11/2015				**	Reviewed for compliance with database standards and recommendations **
***********************************************************************************************************************/
CREATE PROCEDURE [dbo].[spInactivateOrderedTestResults]
(
	@orderedtestguid	UNIQUEIDENTIFIER,
	@inactivatedate		DATETIME,
	@inactivateuser		VARCHAR(30),
	@lastupdateuser		VARCHAR(30),
	@divisioncode		VARCHAR(5),
	@orderabletestid	INT = NULL,
	@specimentestrowversion			TIMESTAMP = NULL,
	@antiseraorderedtestrowversion	TIMESTAMP = NULL,
	@racklotrowversion		TIMESTAMP = NULL,
	@racktestrowversion		TIMESTAMP = NULL,
	@orderedtestrowversion	TIMESTAMP = NULL,
	@lastupdatefunctionid	INT,
	@lastupdatedate			DATETIME
)

AS


DECLARE @ERROR INT

SET @ERROR = 0

SET NOCOUNT ON

DECLARE	@countalltestswithoutnulls	INT
DECLARE	@countalltests				INT
DECLARE @countlotnumbers			INT

IF @orderabletestid IS NOT NULL
BEGIN
	
	UPDATE 
		dbo.SpecimenTest 
	SET	
		RecordStatusCode = 'X',
		InactivateDate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @inactivatedate),
		InactivateUser = @inactivateuser,
		LastUpdateUser = @lastupdateuser,
		LastUpdateDate = @lastupdatedate,
		LastUpdateFunctionId = @lastupdatefunctionid

	WHERE 
		OrderedTestGUID = @orderedtestguid	
	AND	DivisionCode = @divisioncode
	AND	RecordStatusCode = 'A'
	AND	BloodTestTypeID IN (SELECT BloodTestTypeID FROM dbo.BloodTestType
							WHERE BloodTestName IN (SELECT BloodTestName FROM dbo.BloodTestType
													WHERE OrderableTestID = @orderabletestid)
							AND OrderableTestID IN (SELECT OrderableTestID FROM dbo.OrderedTest
													WHERE OrderedTestGUID = @orderedtestguid))
	SET @ERROR = @@ERROR

END

ELSE

BEGIN
	UPDATE 
		dbo.SpecimenTest 
	SET
		RecordStatusCode = 'X',
		LastUpdateUser = @lastupdateuser,
		LastUpdateDate = @lastupdatedate,
		LastUpdateFunctionId = @lastupdatefunctionid
	WHERE 
		OrderedTestGUID = @orderedtestguid	
	AND	DivisionCode = @divisioncode
	AND	RecordStatusCode = 'A'

	SET @ERROR = @@ERROR
END

IF @orderabletestid NOT IN (1,3,7,8,9,10,111,113,118,119)
	OR
   @orderabletestid IS NULL

BEGIN

	UPDATE 
		dbo.AntiseraOrderedTest 
	SET
		RecordStatusCode = 'X',
		LastUpdateUser = @lastupdateuser,
		LastUpdateDate = @lastupdatedate,
		LastUpdateFunctionId = @lastupdatefunctionid
	WHERE 
		OrderedTestGUID = @orderedtestguid	

	SET @ERROR = @@ERROR
			
	UPDATE 
		dbo.RackLot
	SET
		RecordStatusCode = 'X',
		LastUpdateUser = @lastupdateuser,
		LastUpdateDate = @lastupdatedate,
		LastUpdateFunctionId = @lastupdatefunctionid
	WHERE 
		RackLotGUID IN (
						SELECT RackLot.RackLotGUID
						FROM dbo.RackLot
						JOIN dbo.AntiseraOrderedTest ON dbo.AntiseraOrderedTest.RackLotGUID = dbo.RackLot.RackLotGUID
						WHERE 
							dbo.AntiseraOrderedTest.OrderedTestGUID = @orderedtestguid
						AND dbo.RackLot.DivisionCode = @divisioncode
						)

	SET @ERROR = @@ERROR

	UPDATE 
		dbo.RackTest
	SET
		RecordStatusCode = 'X',
		LastUpdateUser = @lastupdateuser,
		LastUpdateDate = @lastupdatedate,
		LastUpdateFunctionId = @lastupdatefunctionid
	WHERE 
		RackLotGUID IN (
						SELECT RackLot.RackLotGUID
						FROM dbo.RackLot
						JOIN 	dbo.AntiseraOrderedTest ON dbo.AntiseraOrderedTest.RackLotGUID = dbo.RackLot.RackLotGUID
						WHERE 
							dbo.AntiseraOrderedTest.OrderedTestGUID = @orderedtestguid
						AND dbo.RackLot.DivisionCode = @divisioncode
						)

	SET @ERROR = @@ERROR
END


SELECT @countalltests = COUNT(1) 
FROM 
	dbo.SpecimenTest 
WHERE
 	OrderedTestGUID = @orderedtestguid	
AND	DivisionCode = @divisioncode
AND	RecordStatusCode = 'A'

SET @ERROR = @@ERROR



SELECT @countalltestswithoutnulls = COUNT(1) 
FROM 
	dbo.SpecimenTest 
WHERE
	OrderedTestGUID = @orderedtestguid	
AND	DivisionCode = @divisioncode
AND	RecordStatusCode = 'A'
AND	TestResultId IS NOT NULL

SET @ERROR = @@ERROR


SELECT @countlotnumbers = COUNT(1) 
FROM 
	dbo.AntiseraOrderedTest 
WHERE
	OrderedTestGUID = @orderedtestguid	
AND	RecordStatusCode = 'A'

SET @ERROR = @@ERROR

--For TAS if there are any tests left and they are all nulls then we should invalidate all of them and set task status to Not Tested
IF @countalltests > 0 AND @countalltestswithoutnulls = 0 AND @countlotnumbers = 0
BEGIN
	UPDATE 
		dbo.SpecimenTest 
	SET
		RecordStatusCode = 'X',
		LastUpdateUser = @lastupdateuser,
		LastUpdateDate = @lastupdatedate,
		LastUpdateFunctionId = @lastupdatefunctionid
	WHERE 
		OrderedTestGUID = @orderedtestguid	
	AND	DivisionCode = @divisioncode
	AND	RecordStatusCode = 'A'

	SET @ERROR = @@ERROR
END

IF @countalltestswithoutnulls = 0 AND @countlotnumbers = 0
BEGIN
	UPDATE 
		dbo.OrderedTest
	SET
		TaskStatusCode = 'N',
		LastUpdateUser = @lastupdateuser,
		LastUpdateDate = @lastupdatedate,
		LastUpdateFunctionId = @lastupdatefunctionid
	WHERE 
		OrderedTest.OrderedTestGUID = @orderedtestguid
	AND	OrderedTest.DivisionCode = @divisioncode

	SET @ERROR = @@ERROR
END

ELSE
BEGIN
	UPDATE
		dbo.OrderedTest
	SET
		TaskStatusCode = 'P',
		LastUpdateUser = @lastupdateuser,
		LastUpdateDate = @lastupdatedate,
		LastUpdateFunctionId = @lastupdatefunctionid
	WHERE 
		OrderedTest.OrderedTestGUID = @orderedtestguid
	AND	OrderedTest.DivisionCode = @divisioncode

	SET @ERROR = @@ERROR
END

SET NOCOUNT OFF

RETURN (@ERROR)
GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spUpdateBloodUnitModification]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spUpdateBloodUnitModification]
GO

/****** Object:  StoredProcedure [dbo].[spUpdateBloodUnitModification]    Script Date: 5/11/2015 10:53:21 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO

/*******************************************************************************************************************************************************************************
**	Desc:	Update blood unit modification (primary use - Add/Remove Units from Pool) - UC24
**
**	Author:	
**
**	Date: 	03/28/2005
***********************************************************************************************************************
**	Modified:
**	Date		Name		Description
**	-------		------		---------------------------------------
**	03/28/2005		Initial Draft.
**	05/31/2005			Adding PoolEditedIndicator
**	06/27/2005	      	Reviewed for compliance with database standards and recommendations.  SET NOCOUNT on and off.
**							Added dbo. to updated table.
**	07/20/2005			Adding Comments field -- for pool edits , step E.7 of UC
**	07/21/2005			Adding OriginalUnitIndicator
**	08/07/2005	     	Capitalized reserved words.  Set ModificationDate outside of update statement.
**							Added error handling on date function conversion.
**	08/21/2005		** Reviewed for compliance with database standards and recommendations **
**							Performed secondary review during the code promotion - merged changes
**	09/02/2005			Changed comments field length from 255 to 510
**	11/17/2005			Adding ModificationCost
**	01/23/2006	     		** Reviewed for compliance with database standards and recommendations **
**	05/08/2015			CR3555 - replacing (= NULL) with (IS NULL) to utilize ANSI_NULLS ON, formatting
**	05/11/2015		**	Reviewed for compliance with database standards and recommendations **
***********************************************************************************************************************/
CREATE PROCEDURE [dbo].[spUpdateBloodUnitModification]
(
	@bloodunitmodificationguid	UNIQUEIDENTIFIER, 
	@modificationdate			DATETIME,
	@modificationtechid			VARCHAR(30),
	@newlabelverificationdatetime	DATETIME = NULL,
	@recordstatuscode			CHAR(1),
	@lastupdateuser				VARCHAR(30),
	@lastupdatefunctionid		INT,
	@rowversion					TIMESTAMP,
	@lastupdatedate				DATETIME,
	@divisioncode				CHAR(5),
	@pooleditedindicator		BIT = 0,
	@comments					VARCHAR(510) = NULL,
	@originalunitindicator		BIT,
	@modificationcost			USMoney
)				

AS

SET NOCOUNT ON

DECLARE	@error			INT,
		@rowcount		INT,
		@converteddate	DATETIME,
		@convertedmodificationdate	DATETIME

	IF (@newlabelverificationdatetime IS NULL)
		SET @converteddate = NULL
	ELSE
		SET @converteddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @newlabelverificationdatetime)

	SET @error = @@ERROR
	IF @error <> 0 GOTO ERR_HANDLER
		
	SET @convertedmodificationdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @modificationdate)

	SET @error = @@ERROR
	IF @error <> 0 GOTO ERR_HANDLER

	UPDATE
		dbo.BloodUnitModification
	SET	
		ModificationDate = @convertedmodificationdate,
		ModificationTechId = @modificationtechid,
		NewLabelVerificationDatetime =  @converteddate,
		PoolEditedIndicator = @pooleditedindicator,
		RecordStatusCode = @recordstatuscode,
		LastUpdateDate = @lastupdatedate,
		LastUpdateUser = @lastupdateuser,
		LastUpdateFunctionId = @lastupdatefunctionid,
		Comments = @comments,
		OriginalUnitIndicator = @originalunitindicator,
		ModificationCost = @modificationcost
	WHERE
	 	BloodUnitModificationGuid = @bloodunitmodificationguid
	AND	[RowVersion] = @rowversion

SELECT @error = @@ERROR, @rowcount = @@rowcount

IF @error = 0 AND @rowcount <> 1 AND ( SELECT COUNT(1) FROM dbo.BloodUnitModification  WHERE [RowVersion] = @rowversion ) <> 1 
	RAISERROR(50001, 16, 127)
ELSE
	IF (@error = 0 AND @rowcount <> 1)	
		SET @error = -1

ERR_HANDLER:

SET NOCOUNT OFF

RETURN(@error)

GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[fnGetInappropriateNonSurgicalRequests]') and xtype in (N'FN', N'IF', N'TF'))
drop function dbo.[fnGetInappropriateNonSurgicalRequests]

/****** Object:  UserDefinedFunction [dbo].[fnGetInappropriateNonSurgicalRequests]    Script Date: 5/11/2015 11:20:06 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO

/**********************************************************************************************************************
**
**  Desc:	Gets inappropriate non-surgical transfusion requests in a division within a specified datetime range. 
**
**  Author:	
**
**  Date: 	02/27/2005
**
***********************************************************************************************************************
**	Modified:
**	Date		Name			Description
**  -------		----------		-----------------------------------------------------
**	07/07/2005			** Reviewed for compliance with database standards and recommendations **
**								reformatted SQL, updated the comment header, added dbo prefix to table names
**
**	04/22/2006				Adding TimZone Conversion for OrderPlacedDateTime
**	06/15/2012		Removed filtering of orders based on OrderStatus. Now expired and cancelled orders will be included (CR 3231)
**	06/22/2012				** Reviewed for compliance with database standards and recommendations **
**	05/08/2015				CR3555 - reformatting to convert UTC parameters outside the query - faster performance
**	05/11/2015			**	Reviewed for compliance with database standards and recommendations **
***********************************************************************************************************************/
CREATE FUNCTION [dbo].[fnGetInappropriateNonSurgicalRequests]
(
    @startdate DATETIME,
    @enddate DATETIME,
    @divisioncode CHAR(5)
)
RETURNS @resultSet TABLE 
(
	TreatingSpecialtyName	VARCHAR(50), 
	RequestingProvider		VARCHAR(82), --50 for FirstName, 30 for LastName, 2 for comma + space
	PatientFullName			VARCHAR(94), --30 for FirstName, 30 for LastName, 30 for MiddleName + 2 x 2 for comma + space
	DisplayVistAPatientId	VARCHAR(15),
	RequiredDateTime		DATETIME,
	ComponentClassShortName VARCHAR(25),
	RequiredUnitQuantity	DECIMAL(3,0),
	SpecimenCollectionDate	DATETIME,
	VistaLaboratoryTestName VARCHAR(50),
	TestResult				VARCHAR(60),
	AcceptedByLoginName		VARCHAR(30),
	AcceptedByUserName		VARCHAR(50),
	ComponentClassSortColumn	SMALLINT,
	PatientOrderPlacedDateTime	DATETIME
)
AS 
BEGIN

	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)
	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	INSERT INTO @resultSet
		SELECT					
			dbo.TreatingSpecialty.TreatingSpecialtyName AS TreatingSpecialtyName, -- nullable
			dbo.PatientOrder.OrderingProviderLastName + ', ' + dbo.PatientOrder.OrderingProviderFirstName AS RequestingProvider, -- nullable
			dbo.Patient.PatientLastName + ', ' + dbo.Patient.PatientFirstName + ISNULL( ', ' + dbo.Patient.PatientMiddleName, '' ) AS PatientFullName,
			dbo.Patient.DisplayVistAPatientId, -- nullable
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, dbo.OrderedComponent.RequiredDateTime ) AS RequiredDateTime, -- nullable
			dbo.ComponentClass.ComponentClassShortName,
			dbo.OrderedComponent.RequiredUnitQuantity,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, dbo.PatientSpecimen.SpecimenCollectionDate ) AS SpecimenCollectionDate, -- nullable
			dbo.SpecimenTestThreshold.VistaLaboratoryTestName,
			dbo.PatientTest.TestResult,
			dbo.VbecsUser.VbecsUserId AS AcceptedByLoginName, -- nullable
			dbo.VbecsUser.UserName AS AcceptedByUserName,  -- nullable
			dbo.ComponentClass.SortColumn AS ComponentClassSortColumn,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, dbo.PatientOrder.OrderPlacedDateTime) AS PatientOrderPlacedDateTime
		FROM		
            dbo.OrderedComponent
		INNER JOIN
			dbo.PatientOrder ON dbo.PatientOrder.PatientOrderGuid = dbo.OrderedComponent.PatientOrderGuid
		INNER JOIN	
			dbo.PatientTreatment ON dbo.PatientOrder.PatientTreatmentGuid = dbo.PatientTreatment.PatientTreatmentGuid
		INNER JOIN	
			dbo.Patient ON dbo.Patient.PatientGuid = dbo.PatientTreatment.PatientGuid
		INNER JOIN	
			dbo.ComponentClass ON dbo.ComponentClass.ComponentClassId = dbo.OrderedComponent.ComponentClassId
		LEFT OUTER JOIN
			dbo.TreatingSpecialty ON dbo.TreatingSpecialty.TreatingSpecialtyCode = dbo.PatientTreatment.TreatingSpecialtyCode
		LEFT OUTER JOIN		
			dbo.PatientSpecimen ON dbo.PatientSpecimen.PatientSpecimenGuid = dbo.OrderedComponent.PatientSpecimenGuid
		LEFT OUTER JOIN
			dbo.PatientTest ON dbo.PatientTest.PatientOrderGuid = dbo.OrderedComponent.PatientOrderGuid 
								AND dbo.PatientTest.DivisionCode = dbo.OrderedComponent.DivisionCode
								AND dbo.PatientTest.RecordStatusCode <> 'X'
		LEFT OUTER JOIN 
			dbo.SpecimenTestThreshold ON dbo.SpecimenTestThreshold.LabTestId = dbo.PatientTest.LabTestId 
								AND dbo.SpecimenTestThreshold.ComponentClassId = dbo.OrderedComponent.ComponentClassId
								AND dbo.SpecimenTestThreshold.DivisionCode = dbo.OrderedComponent.DivisionCode
								AND dbo.SpecimenTestThreshold.RecordStatusCode = 'A'
								AND dbo.SpecimenTestThreshold.ReportTypeId = 9 		
		LEFT OUTER JOIN 
			SynMirror_V_OrderedComponent OCMirror ON OCMirror.OrderedComponentGuid = dbo.OrderedComponent.OrderedComponentGuid
								AND OCMirror.OrderStatusCode = 'A'
								AND OCMirror.MirrorId = 
									( SELECT  MIN( OCMirror.MirrorId )
										FROM
											SynMirror_V_OrderedComponent OCMirror 
										WHERE   
											OCMirror.OrderedComponentGuid = OrderedComponent.OrderedComponentGuid
										AND OCMirror.OrderStatusCode = 'A'
										AND OCMirror.MirrorDate =	( SELECT MIN( OCMirror.MirrorDate )
																	FROM   
																		SynMirror_V_OrderedComponent OCMirror 
																	WHERE  
																		OCMirror.OrderedComponentGuid = dbo.OrderedComponent.OrderedComponentGuid 
																	AND OCMirror.OrderStatusCode = 'A' 
																	) 
									) 
		LEFT OUTER JOIN
			dbo.VbecsUser ON dbo.VbecsUser.VbecsUserId = OCMirror.LastUpdateUser 	
	WHERE     
		dbo.OrderedComponent.InappropriateRequestIndicator = 1
	AND dbo.OrderedComponent.DivisionCode = @divisionCode
	AND dbo.PatientOrder.OrderPlacedDateTime BETWEEN @startdate AND @enddate
	AND dbo.OrderedComponent.PreopIndicator = 0 
	AND EXISTS ( SELECT TOP 1 1
				FROM
					SynMirror_V_OrderedComponent OCMirror 
				WHERE
					OCMirror.OrderedComponentGuid = OrderedComponent.OrderedComponentGuid 
				AND OCMirror.OrderStatusCode = 'A' 
				)
RETURN
END

GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[fnGetInappropriateSurgicalRequests]') and xtype in (N'FN', N'IF', N'TF'))
drop function dbo.[fnGetInappropriateSurgicalRequests]

/****** Object:  UserDefinedFunction [dbo].[fnGetInappropriateSurgicalRequests]    Script Date: 5/11/2015 12:09:11 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO

/*****************************************************************************************************************
**
**	Desc:	Gets inappropriate surgicaltransfusion requests in a division within a specified datetime range. 
**
**	Author:	
**
**	Date: 	02/27/2005
**
***********************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	---------	---------		-----------------------------------------------------
**	07/07/2005			** Reviewed for compliance with database standards and recommendations **
**								reformatted SQL, updated the comment header, added dbo prefix to table names
**
**	04/22/2006				Adding TimeZoneConversion to OrderPlacedDateTime
**	06/15/2012		Removed filtering of orders based on OrderStatus. Now expired and cancelled orders will be included (CR 3231)
**	06/22/2012				** Reviewed for compliance with database standards and recommendations **
**	05/08/2015				CR3555 - reformatting to convert UTC parameters outside the query - faster performance
**	05/11/2015			**	Reviewed for compliance with database standards and recommendations **
***********************************************************************************************************************/
CREATE FUNCTION [dbo].[fnGetInappropriateSurgicalRequests]
(
	@startdate DATETIME,
	@enddate DATETIME,
	@divisioncode CHAR(5)
)
RETURNS @returnTable TABLE 
(
    TreatingSpecialtyName	VARCHAR(50), 
	RequestingProvider		VARCHAR(82), --50 for FirstName, 30 for LastName, 2 for comma + space
	SurgeryName				VARCHAR(50),
	PatientFullName			VARCHAR(94), --30 for FirstName, 30 for LastName, 30 for MiddleName + 2 x 2 for comma + space
	DisplayVistAPatientId	VARCHAR(15),
	RequiredDateTime		DATETIME,
	ComponentClassShortName VARCHAR(25),
	RequiredUnitQuantity	DECIMAL(3,0),
	AcceptedByLoginName		VARCHAR(30),
	AcceptedByUserName		VARCHAR(50),
	ComponentClassSortColumn	SMALLINT,
	PatientOrderPlacedDateTime	DATETIME
)
AS 

BEGIN

	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)
	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	INSERT INTO @returnTable
		SELECT					
			dbo.TreatingSpecialty.TreatingSpecialtyName, -- nullable
			dbo.PatientOrder.OrderingProviderLastName + ', ' + dbo.PatientOrder.OrderingProviderFirstName AS RequestingProvider, -- nullable
			dbo.MsBos.SurgeryName, -- nullable
			dbo.Patient.PatientLastName + ', ' + dbo.Patient.PatientFirstName + ISNULL( ', ' + dbo.Patient.PatientMiddleName, '' ) AS PatientFullName,
			dbo.Patient.DisplayVistAPatientId, -- nullable
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, dbo.OrderedComponent.RequiredDateTime) AS RequiredDateTime, -- nullable
			dbo.ComponentClass.ComponentClassShortName,			
			dbo.OrderedComponent.RequiredUnitQuantity,
			dbo.VbecsUser.VbecsUserId AS AcceptedByLoginName, -- nullable
			dbo.VbecsUser.UserName AS AcceptedByUserName,  -- nullable
			dbo.ComponentClass.SortColumn AS ComponentClassSortColumn,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, dbo.PatientOrder.OrderPlacedDateTime) AS PatientOrderPlacedDateTime
		FROM		
			dbo.OrderedComponent
		INNER JOIN	
			dbo.PatientOrder ON dbo.PatientOrder.PatientOrderGuid = dbo.OrderedComponent.PatientOrderGuid
		INNER JOIN	
			dbo.PatientTreatment ON dbo.PatientOrder.PatientTreatmentGuid = dbo.PatientTreatment.PatientTreatmentGuid
		INNER JOIN	
			dbo.Patient ON dbo.Patient.PatientGuid = dbo.PatientTreatment.PatientGuid
		INNER JOIN	
			dbo.ComponentClass ON dbo.ComponentClass.ComponentClassId = dbo.OrderedComponent.ComponentClassId
		LEFT OUTER JOIN
			dbo.TreatingSpecialty ON dbo.TreatingSpecialty.TreatingSpecialtyCode = dbo.PatientTreatment.TreatingSpecialtyCode
		LEFT OUTER JOIN
			dbo.Msbos ON dbo.Msbos.SurgeryName = dbo.PatientOrder.SurgeryName 
						AND dbo.Msbos.DivisionCode = dbo.OrderedComponent.DivisionCode 
						AND dbo.Msbos.RecordStatusCode = 'A'
		LEFT OUTER JOIN 
				SynMirror_V_OrderedComponent OCMirror ON OCMirror.OrderedComponentGuid = OrderedComponent.OrderedComponentGuid 
						AND	OCMirror.OrderStatusCode = 'A'
						AND	OCMirror.MirrorId = (
												SELECT  MIN( OCMirror.MirrorId )
												FROM
													SynMirror_V_OrderedComponent OCMirror 
												WHERE
													OCMirror.OrderedComponentGuid = dbo.OrderedComponent.OrderedComponentGuid
												AND OCMirror.OrderStatusCode = 'A' 
												AND OCMirror.MirrorDate =  
																		( SELECT  MIN( OCMirror.MirrorDate )
																			FROM
																				SynMirror_V_OrderedComponent OCMirror
																			WHERE
																				OCMirror.OrderedComponentGuid = dbo.OrderedComponent.OrderedComponentGuid
																			AND OCMirror.OrderStatusCode = 'A' 
																		) 
												) 
		LEFT OUTER JOIN
			VbecsUser ON VbecsUser.VbecsUserId = OCMirror.LastUpdateUser 	
		WHERE		
			dbo.OrderedComponent.InappropriateRequestIndicator = 1
		AND dbo.OrderedComponent.DivisionCode = @divisionCode
		AND dbo.PatientOrder.OrderPlacedDateTime BETWEEN @startdate AND @enddate 
		AND dbo.OrderedComponent.PreopIndicator = 1
		AND EXISTS 
				(SELECT TOP 1 1
                FROM    
					SynMirror_V_OrderedComponent OCMirror 
                WHERE
					OCMirror.OrderedComponentGuid = dbo.OrderedComponent.OrderedComponentGuid 
                AND OCMirror.OrderStatusCode = 'A' 
				)
RETURN
END


GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[fnGetProlongedTransfusionsForSpecifiedRange]') and xtype in (N'FN', N'IF', N'TF'))
drop function dbo.[fnGetProlongedTransfusionsForSpecifiedRange]

/****** Object:  UserDefinedFunction [dbo].[fnGetProlongedTransfusionsForSpecifiedRange]    Script Date: 5/11/2015 12:18:15 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO

/*********************************************************************************************************************
**
**  Desc:  Gets all prolonged transfusions in a division within a specified datetime range. Supplies unsorted 
**         data for the report sproc that sorts the data according to report criterion.
**
**  Author:
**
**  Date:   10/25/2004
**
***********************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	---------	------------	-----------------------------------
**	06/27/2005			Changed to use new view
**	07/11/2005			** Reviewed for compliance with database standards and recommendations **
**								reformatted SQL, added object owners, removed unneeded local variable
**
**	09/29/05			Modified join on TreatingSpecialty to be LEFT OUTER instead of INNER
**								in order to return patients that are outgoing and therefore have no treating specialty.				
**
**	01/17/2006			Added FullProductCode (UnitProductCode, DonationTypeCode, UnitDivisionId) to ProductShortName (DR 1729)
**	01/23/2006	    			** Reviewed for compliance with database standards and recommendations **
**	01/04/2010	      		Checked UnitStatusCode from the BloodUnitStatusCodeCurrent table to determine
**								transfused units. (CR 1174)
**	01/25/2010			** Reviewed for compliance with database standards and recommendations **
**	05/08/2015				CR3555 - reformatting to convert UTC parameters outside the query - faster performance
**	05/11/2015			**	Reviewed for compliance with database standards and recommendations **
***********************************************************************************************************************/
CREATE FUNCTION [dbo].[fnGetProlongedTransfusionsForSpecifiedRange]
(
        @startdate                              		DATETIME,
        @enddate                                		DATETIME,
        @delayedtransfusiontimethresholdminutes 	INT,
        @divisioncode                           		CHAR(5)
)
RETURNS @returnTable TABLE 
(
    IssueToLocationName		VARCHAR(30), 
	PatientFullName			VARCHAR(94), --30 for FirstName, 30 for LastName, 30 for MiddleName + 2 x 2 for comma + space
	DisplayVistAPatientId	VARCHAR(15),
	EyeReadableUnitId		VARCHAR(13),
	ProductShortName		VARCHAR(50),
	IssueDateTime			DATETIME,
	TransfusionStartDateTime	DATETIME,
	TransfusionEndDateTime		DATETIME,
	DelayedTransfusionTime		INT,
	ProlongedTransfusionTime	INT,
	TotalAdministrationTime		INT,
    TreatingSpecialtyName		VARCHAR(50)

)
AS 

BEGIN

	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)
	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)

	INSERT INTO @returnTable
	SELECT	
		IssueToLocationName,
		PatientFullName,
		DisplayVistAPatientId,
		EyeReadableUnitId,
		ProductShortName,
		IssueDateTime,
		TransfusionStartDateTime,
		TransfusionEndDateTime,
		DelayedTransfusionTime,
		ProlongedTransfusionTime,
		TotalAdministrationTime,
		TreatingSpecialtyName
	FROM
	(		
		SELECT	
			dbo.IssuedUnit.IssueToLocationName,
			dbo.Patient.PatientLastName + ', ' + dbo.Patient.PatientFirstName + ISNULL( ', ' + dbo.Patient.PatientMiddleName, '' ) AS PatientFullName,
			ISNULL( dbo.Patient.DisplayVistAPatientId, '' ) AS DisplayVistAPatientId,
			ISNULL( dbo.vw_BloodShipAllCurrent.EyeReadableUnitId, '' ) AS EyeReadableUnitId,
			CASE dbo.vw_BloodShipAllCurrent.LabelTypeCode
				WHEN 'I' THEN 
					dbo.vw_BloodShipAllCurrent.ProductShortName+', '+dbo.vw_BloodShipAllCurrent.UnitProductCode + dbo.vw_BloodShipAllCurrent.DonationTypeCode COLLATE SQL_Latin1_General_CP1_CS_AS + dbo.vw_BloodShipAllCurrent.UnitDivisionId 
				ELSE 
					dbo.vw_BloodShipAllCurrent.ProductShortName+', '+dbo.vw_BloodShipAllCurrent.UnitProductCode
			END AS ProductShortName,
			dbo.fnTimeZoneConversionDateTime( @divisioncode, 0, dbo.IssuedUnit.IssueDateTime ) AS IssueDateTime,
			dbo.fnTimeZoneConversionDateTime( @divisioncode, 0, dbo.PatientTransfusion.TransfusionStartDateTime ) AS TransfusionStartDateTime,
			dbo.fnTimeZoneConversionDateTime( @divisioncode, 0, dbo.PatientTransfusion.TransfusionEndDateTime ) AS TransfusionEndDateTime,
			DATEDIFF( mi, dbo.IssuedUnit.IssueDateTime, dbo.PatientTransfusion.TransfusionStartDateTime ) AS DelayedTransfusionTime, --BR_105.04
			DATEDIFF( mi, ISNULL( dbo.PatientTransfusion.TransfusionStartDateTime, dbo.IssuedUnit.IssueDateTime ), dbo.PatientTransfusion.TransfusionEndDateTime ) AS ProlongedTransfusionTime, -- BR_105.03
			DATEDIFF( mi, dbo.IssuedUnit.IssueDateTime, dbo.PatientTransfusion.TransfusionEndDateTime ) AS TotalAdministrationTime, -- BR_105.06
			dbo.ComponentClassParameter.MaximumTransfusionTime,
			dbo.TreatingSpecialty.TreatingSpecialtyName
		FROM    
			dbo.PatientTransfusion
		INNER JOIN	
			dbo.Patient ON dbo.Patient.PatientGuid = dbo.PatientTransfusion.PatientGuid
		INNER JOIN	
			dbo.IssuedUnit ON dbo.IssuedUnit.BloodUnitGuid = dbo.PatientTransfusion.BloodUnitGuid 
							AND dbo.IssuedUnit.ReturnDateTime IS NULL
		INNER JOIN	
			dbo.vw_BloodShipAllCurrent ON vw_BloodShipAllCurrent.BloodUnitGuid = PatientTransfusion.BloodUnitGuid
		INNER JOIN	
			dbo.ComponentClassParameter ON dbo.ComponentClassParameter.ComponentClassId = dbo.vw_BloodShipAllCurrent.ComponentClassId 
							AND dbo.ComponentClassParameter.DivisionCode = @divisioncode
	    JOIN 
			dbo.BloodUnitStatusCodeCurrent	BUSCC ON dbo.PatientTransfusion.BloodUnitGuid = BUSCC.BloodUnitGuid
		INNER JOIN	
			dbo.OrderedUnit ON dbo.OrderedUnit.BloodUnitGuid = dbo.PatientTransfusion.BloodUnitGuid
		INNER JOIN
			dbo.OrderedComponent ON dbo.OrderedComponent.OrderedComponentGuid = dbo.OrderedUnit.OrderedComponentGuid
		INNER JOIN 
			dbo.PatientOrder ON dbo.PatientOrder.PatientOrderGuid = dbo.OrderedComponent.PatientOrderGuid
		INNER JOIN 
			dbo.PatientTreatment ON dbo.PatientTreatment.PatientTreatmentGuid = dbo.PatientOrder.PatientTreatmentGuid
		LEFT OUTER JOIN 
			dbo.TreatingSpecialty ON TreatingSpecialty.TreatingSpecialtyCode = dbo.PatientTreatment.TreatingSpecialtyCode
		WHERE	
			-- Presumed transfused should not be included in the report
			NOT EXISTS	(	SELECT TOP 1 1 
							FROM   
								dbo.BloodUnitStatus
							WHERE  
								dbo.BloodUnitStatus.BloodUnitGuid = dbo.vw_BloodShipAllCurrent.BloodUnitGuid 
							AND dbo.BloodUnitStatus.PresumedTransfusedIndicator = 1 
						)
		-- We're interested in transfused units only
		AND BUSCC.UnitStatusCode = 'T' 
		AND dbo.OrderedUnit.ReleaseDate IS NULL
		AND dbo.PatientTransfusion.DivisionCode = @divisioncode
		AND dbo.PatientTransfusion.RecordStatusCode = 'A'
		-- We don't care about patient record status - patient can be dead by the time report is pulled
		-- We also don't care about ComponentClassParameter record status since we need data at a time report is created
		-- And... IssuedUnit doesn't have RecordStatusCode column!
		AND dbo.IssuedUnit.IssueDateTime BETWEEN @startdate AND @enddate
    ) AllUnitsTransfusedInSpecifiedTimeFrame
    WHERE		
		DelayedTransfusionTime > @delayedtransfusiontimethresholdminutes -- BR_105.04
	OR	ProlongedTransfusionTime > MaximumTransfusionTime -- BR_105.03;

RETURN
END

GO


/*** VBECS 2.1.0.2 SQL Script ***/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[spGetTransfusionRequirementsReport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spGetTransfusionRequirementsReport]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER OFF
GO

/******************************************************************************************************************************************
**	Desc:	Get all transfusion requirements, SIs and TRs for all not deceased patient.
**			Used in UC 89 Report. Start and End dates are optional and ony used with partial report.
**
**	Author:	
**
**	Date:	8/17/2003
**
*******************************************************************************************************************************************
**	Modified:
**	Date		Name			Description
**	----------	--------		-----------------------------------------------------------------------------------------------------------
**	02/22/2005			Removed the division filter on the selection of special instructions.
**	03/30/2005			Changed 1st query to outer joins; these patients are then filtered for valid data in the BOL
**	06/08/2005			Modified query to select patients whose ABORH status may have changed within the date ranged passed in.  
**								Previously was not returning
**								patients that only had an ABORH change, and was not returning patients newly added to the system when 
**								a date range was used.
**	07/05/2005		** Reviewed for compliance with database standards and recommendations **
								Removed name, input/output descritpions from comment header, added nocount, spaced SQL, 
**								specified object owners
**	09/09/2005			Changed JOIN on Patient to select either the FinalMergeToPatient if the patient has one or more
**								merges (choosing the final merge record) or simply the patient guid if there are none
**	01/06/2006			Changed formatting for readibility; added AND to WHERE clause in (3) to only get active TRs
**	01/23/2006	     		** Reviewed for compliance with database standards and recommendations **
**	09/16/2015				CR 3575 - fixed COLLATE in section 3 - to correctly join lower/upper case Reqs w/o truncation. Reformats.
**	09/16/2015			** Reviewed for compliance with database standards and recommendations ** 
*******************************************************************************************************************************************/
CREATE PROCEDURE [dbo].[spGetTransfusionRequirementsReport]
(
	@divisioncode	VARCHAR(5),
	@startdate	DATETIME = NULL,
	@enddate	DATETIME = NULL 
)
AS

	SET NOCOUNT ON

	DECLARE @ERROR INT
	SET @ERROR = 0
	
	--Since all the dates are saved in UTC, start and end data has to be adjusted first for correct comparison
	SET @startdate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @startdate)
	SET @ERROR = @@ERROR
	IF @ERROR != 0 GOTO ERR_HANDLER
	
	SET @enddate = dbo.fnTimeZoneConversionDateTime(@divisioncode, 1, @enddate)
	SET @ERROR = @@ERROR
	IF @ERROR != 0 GOTO ERR_HANDLER
	
	
	-- (1)
	--First get any records that have had an ABORH Test performed within the date range specified
	SELECT DISTINCT
		--Guids
		P.PatientGuid,
		--Patient Info
		P.PatientLastName,
		P.PatientFirstName,
		P.PatientMiddleName,
		P.DisplayVistaPatientId,
		SPACE(12) as ABORh,
		'' AS ABORhDate,
		'' AS ABORhDivision,
		--Detail section
		NULL AS Category,
		NULL AS RequirementText,
		NULL AS DateEntered,
		NULL AS DivisionCode
	FROM 	
			dbo.Patient P
		
		INNER JOIN	dbo.PatientSpecimen PS	
					ON PS.PatientGuid = P.PatientGuid
		
		INNER JOIN	dbo.SpecimenTest ST
					ON ST.PatientSpecimenGuid = PS.PatientSpecimenGUID
		
	WHERE
			(ST.BloodTestTypeID = 21 OR ST.BloodTestTypeID = 68 OR ST.BloodTestTypeID = 18 OR ST.BloodTestTypeID = 65)
	
		AND	ST.LastUpdateDate >= @startdate 
		
		AND	ST.LastUpdateDate <= @enddate
			
		AND	P.PatientDeathDate IS NULL
				
		AND	@startDate IS NOT NULL 
					
		AND	@enddate IS NOT NULL
	
	UNION
	
	-- (2)
	--Also get any patients whose patient record has been updated within the date range specified.  This does not guarantee that it was 
	--an ABORH update, but there appears to be no other performant way to include these patients, and it cannot hurt to add a 
	--patient to this report displaying their ABORH if it has not changed.
	SELECT DISTINCT
		--Guids
		P.PatientGuid,
		--Patient Info
		P.PatientLastName,
		P.PatientFirstName,
		P.PatientMiddleName,
		P.DisplayVistaPatientId,
		SPACE(12) as ABORh,
		'' AS ABORhDate,
		'' AS ABORhDivision,
		--Detail section
		NULL AS Category,
		NULL AS RequirementText,
		NULL AS DateEntered,
		NULL AS DivisionCode
	
	FROM 	
			dbo.Patient P
	
	WHERE
			P.PatientDeathDate IS NULL
		
		AND	P.LastUpdateDate >= @startdate 
		
		AND	P.LastUpdateDate <= @enddate
			
		AND	@startDate IS NOT NULL 
				
		AND	@enddate IS NOT NULL
	
	UNION
	
	-- (3)
	--Next get transfusion requirements
	SELECT DISTINCT
		--Guids
		P.PatientGuid,
		--Patient Info
		P.PatientLastName,
		P.PatientFirstName,
		P.PatientMiddleName,
		P.DisplayVistaPatientId,
		SPACE(12) as ABORh,
		'' AS ABORhDate,
		'' AS ABORhDivision,
		--Detail section
		TRC.TransfusionRequirementCategoryText AS Category,
		PTR.TransfusionRequirementText COLLATE SQL_Latin1_General_CP1_CS_AS as RequirementText,		--CR3575
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PTR.CreateDate) AS DateEntered,
		D.DivisionName AS DivisionCode
	
	FROM 	
			dbo.Patient P
	
		LEFT OUTER JOIN	dbo.PatientTransfusionRequirement PTR
						ON PTR.PatientGuid = COALESCE(P.FinalMergeToPatient, P.PatientGuid)
	
		LEFT OUTER JOIN dbo.TransfusionRequirementCategory TRC
						ON TRC.TransfusionRequirementCategoryCode = PTR.TransfusionRequirementCategoryCode
	
		LEFT JOIN	dbo.VamcDivision D 
					ON D.DivisionCode = PTR.CreateDivisionCode
		
	WHERE
			P.PatientDeathDate IS NULL

		-- do not get invalidated TRs
		AND	PTR.RecordStatusCode IN ('A', 'C')
	
		AND	( (@startdate IS NOT NULL AND PTR.CreateDate >= @startdate) OR @startdate IS NULL)
	
		AND	( (@enddate IS NOT NULL AND PTR.CreateDate <= @enddate) OR @enddate IS NULL)
	
	UNION
	
	-- (4)
	--Now get derived transfusion requirements
	SELECT DISTINCT
		--Guids
		P.PatientGuid,
		--Patient Info
		P.PatientLastName,
		P.PatientFirstName,
		P.PatientMiddleName,
		P.DisplayVistaPatientId,
		SPACE(12) AS ABORh,
		'' AS ABORhDate,
		'' AS ABORhDivision,
		--Detail section
		TRCC.TransfusionRequirementCategoryText AS Category,
		dbo.AntigenType.AntigenTypeName COLLATE SQL_Latin1_General_CP1_CS_AS as RequirementText,
		dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PTR.CreateDate) AS DateEntered,
		D.DivisionName as DivisionCode
	FROM
			dbo.PatientTransfusionRequirement PTR
		
		JOIN	dbo.TransfusionRequirementCategory TRC
				ON TRC.TransfusionRequirementCategoryCode = PTR.TransfusionRequirementCategoryCode

		JOIN	dbo.TransfusionRequirementCategory TRCC
				ON TRCC.TransfusionRequirementCategoryCode = 'AN'
	
		JOIN	dbo.VamcDivision D
				ON D.DivisionCode = PTR.CreateDivisionCode
	
		JOIN	dbo.AntibodyAntigen
				ON AntibodyAntigen.AntibodyTypeId = PTR.AntibodyTypeId
	
		JOIN	dbo.AntigenType
				ON AntigenType.AntigenTypeId = AntibodyAntigen.AntigenTypeId
	
		JOIN	dbo.AntibodyParameter AP
				ON AP.AntibodyTypeId = PTR.AntibodyTypeId AND AP.DivisionCode = PTR.CreateDivisionCode
	
		JOIN	dbo.Patient LinkPatient
				ON PTR.PatientGuid = LinkPatient.PatientGuid
	
		JOIN	dbo.Patient P	
				ON P.PatientGuid = COALESCE(LinkPatient.FinalMergeToPatient, LinkPatient.PatientGuid)
	
		WHERE
				P.PatientDeathDate IS NULL
	
			AND	( (@startdate IS NOT NULL AND PTR.CreateDate >= @startdate) OR @startdate IS NULL)
		
			AND ( (@enddate IS NOT NULL AND PTR.CreateDate <= @enddate) OR @enddate IS NULL)
		
			AND PTR.TransfusionRequirementCategoryCode = 'AS'
			
			AND AP.HigherLevelOverrideIndicator = 1
				
			-- do not get invalidated TRs
			AND PTR.RecordStatusCode IN ('A', 'C')
	
		UNION
	
	-- (5)
	--Get special instructions
		SELECT DISTINCT
			--Guids

			P.PatientGuid,
			--Patient Info
			P.PatientLastName,
			P.PatientFirstName,
			P.PatientMiddleName,
			P.DisplayVistaPatientId,
			SPACE(12) as ABORh,
			'' AS ABORhDate,
			'' AS ABORhDivision,
			--Detail section
			'Special Instructions' AS Category,
			SI.PatientSpecialInstructions AS RequirementText,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, SI.CreateDate) AS DateEntered,
			D.DivisionName AS DivisionCode
		FROM
				dbo.PatientSpecialInstruction SI
	
			JOIN	dbo.Patient LinkPatient	
					ON SI.PatientGuid = LinkPatient.PatientGuid
	
			JOIN	dbo.Patient P
					ON P.PatientGuid = COALESCE(LinkPatient.FinalMergeToPatient, LinkPatient.PatientGuid)
	
			JOIN	dbo.VamcDivision D
					ON D.DivisionCode = SI.DivisionCode
		
		WHERE
				P.PatientDeathDate IS NULL
	
			AND	( (@startdate IS NOT NULL AND SI.CreateDate >= @startdate) OR @startdate IS NULL)
		
			AND	( (@enddate IS NOT NULL AND SI.CreateDate <= @enddate) OR @enddate IS NULL)
			
			AND	SI.RecordStatusCode IN ('A','C')
	
		UNION
	
		-- (6)
		--Finally get transfusion reactions
		SELECT
			--Guids
			P.PatientGuid,
			--Patient Info
			P.PatientLastName,
			P.PatientFirstName,
			P.PatientMiddleName,
			P.DisplayVistaPatientId,
			SPACE(12) as ABORh,
			'' AS ABORhDate,
			'' AS ABORhDivision,
			--Detail section
			'Transfusion Reactions' AS Category,
			TRT.TransfusionReactionTypeText AS RequirementText,
			dbo.fnTimeZoneConversionDateTime(@divisioncode, 0, PTR.NotedDateTime) AS DateEntered,
			D.DivisionName AS DivisionCode
		FROM
				dbo.PatientTransfusionReaction PTR
	
			JOIN	dbo.Patient LinkPatient	
					ON PTR.PatientGuid = LinkPatient.PatientGuid
	
			JOIN	dbo.Patient P
					ON P.PatientGuid = COALESCE(LinkPatient.FinalMergeToPatient, LinkPatient.PatientGuid)
	
			JOIN	dbo.TransfusionReactionType TRT
					ON TRT.TransfusionReactionTypeCode = PTR.TransfusionReactionTypeCode
	
			JOIN	dbo.VamcDivision D
					ON D.DivisionCode = PTR.DivisionCode
			
		WHERE
				P.PatientDeathDate IS NULL
	
			AND	( (@startdate IS NOT NULL AND PTR.NotedDateTime >= @startdate) OR @startdate IS NULL)
		
			AND	( (@enddate IS NOT NULL AND PTR.NotedDateTime <= @enddate) OR @enddate IS NULL)
		
			AND	PTR.RecordStatusCode IN ('A','C')
	
		ORDER BY 
			P.PatientLastName, P.PatientFirstName, P.PatientMiddleName, P.DisplayVistaPatientId, Category 
	


	SET NOCOUNT OFF

	SET @ERROR = @@ERROR
	IF @ERROR != 0 GOTO ERR_HANDLER
	
	RETURN(@ERROR)

	
ERR_HANDLER:
	SET NOCOUNT OFF
	RETURN @ERROR

GO


--Permissions

GRANT SELECT ON  [dbo].[ProductType] TO [VbecsAppUser]
GO


GRANT SELECT ON  [dbo].[vw_BloodShipPatientAllCurrent] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetBloodProductByCode] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetBloodProductByGuid] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetDailyQCRacks] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetLimitedBloodUnit] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetLimitedBloodUnitsByDivision] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetOrderedUnitByPatientAndUnit] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetReagentLotsForRetest] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spDeleteVbecsLock] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetBloodAvailabilityItems] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetHcpcsAssignmentHistory] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spInactivateOrderedTestResults] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spUpdateBloodUnitModification] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[spGetTransfusionRequirementsReport] TO [VbecsAppUser]
GO

GRANT SELECT ON  [dbo].[fnGetInappropriateNonSurgicalRequests] TO [VbecsAppUser]
GO

GRANT SELECT ON  [dbo].[fnGetInappropriateSurgicalRequests] TO [VbecsAppUser]
GO

GRANT SELECT ON  [dbo].[fnGetProlongedTransfusionsForSpecifiedRange] TO [VbecsAppUser]
GO

GRANT EXECUTE ON  [dbo].[fnUnitStatusCode] TO [VbecsAppUser]
GO




USE @DBNAME@
GO

/*****************************************************
**	Update VbecsVersion
*****************************************************/

DECLARE @SUser	VARCHAR(45)

SET @SUser = SUSER_SNAME()

INSERT INTO dbo.VbecsVersion
(Version, PatchSuccessfulIndicator, LastUpdateDate, LastUpdateUser)
VALUES('2.1.0.3',0, GETUTCDATE(), RIGHT(@SUser, LEN(@SUser) - CHARINDEX('\', @SUser)))


/*****************************************************
**	Update VbecsDBRevision
*****************************************************/

INSERT INTO dbo.VbecsDBRevision
(VbecsVersion, Revision, Comment, LastUpdateDate, LastUpdateUser)
VALUES('2.1.0.3','A', '', GETUTCDATE(), RIGHT(@SUser, LEN(@SUser) - CHARINDEX('\', @SUser)))